﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/nn_SdkAssert.h>
#include <nn/result/result_HandlingUtility.h>
#include "xcd_BluetoothDriver.h"

namespace nn { namespace xcd { namespace detail {

BluetoothDriver::BluetoothDriver() NN_NOEXCEPT :
    m_Mutex(false)
{
    // 何もしない
}

BluetoothDriver::~BluetoothDriver() NN_NOEXCEPT
{
    // 何もしない
}

void BluetoothDriver::Activate() NN_NOEXCEPT
{
    // 何もしない
}

void BluetoothDriver::Deactivate() NN_NOEXCEPT
{
    // 何もしない
}

void BluetoothDriver::EventFunction(const ::nn::os::MultiWaitHolderType* pMultiWaitHolder) NN_NOEXCEPT
{
    NN_UNUSED(pMultiWaitHolder);

    // 何もしない
}

void BluetoothDriver::PeriodicEventFunction() NN_NOEXCEPT
{
    // 何もしない
}

void BluetoothDriver::SetPairingUpdateEvent(::nn::os::SystemEventType* pEvent) NN_NOEXCEPT
{
    ::nn::os::CreateSystemEvent(pEvent, ::nn::os::EventClearMode_AutoClear, false);
    ::nn::os::ClearSystemEvent(pEvent);
}

void BluetoothDriver::StartButtonPairing() NN_NOEXCEPT
{
    // 何もしない
}

BluetoothDeviceInfo BluetoothDriver::GetDeviceInfo() NN_NOEXCEPT
{
    return BluetoothDeviceInfo();
}


bool BluetoothDriver::IsRegisteredDevice(const ::nn::bluetooth::Address address) NN_NOEXCEPT
{
    NN_UNUSED(address);

    return false;
}

int BluetoothDriver::GetRegisteredDevices(BluetoothDeviceInfo pOutValues[], int length) NN_NOEXCEPT
{
    NN_UNUSED(pOutValues);
    NN_UNUSED(length);

    return 0;
}

void BluetoothDriver::RegisterBluetoothDevice(const BluetoothDeviceInfo& deviceInfo) NN_NOEXCEPT
{
    NN_UNUSED(deviceInfo);
    // 何もしない
}

::nn::Result BluetoothDriver::SendConnectionTrigger(const ::nn::bluetooth::Address address, nn::os::EventType* pEvent) NN_NOEXCEPT
{
    NN_UNUSED(address);
    NN_UNUSED(pEvent);
    // 何もしない
    NN_RESULT_SUCCESS;
}

void BluetoothDriver::IncreaseDeviceInfoOrder(const ::nn::bluetooth::Address& address) NN_NOEXCEPT
{
    NN_UNUSED(address);
}

void BluetoothDriver::ProtectDeviceInfo(const ::nn::bluetooth::Address& address, bool protect) NN_NOEXCEPT
{
    NN_UNUSED(address);
    NN_UNUSED(protect);
}

void BluetoothDriver::Suspend() NN_NOEXCEPT
{
    // 何もしない
}

void BluetoothDriver::Resume() NN_NOEXCEPT
{
    // 何もしない
}

}}} // namespace nn::xcd::detail
