﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using nn;
using nn.sf;
using std;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.Hipc;
using Nintendo.ServiceFramework.CppCode;

namespace nn.wlan
{
    [CppRefPath("<nn/wlan/wlan_Types.h>")]
    [ExternalStruct(256, 4)]
    [LargeData(true)]
    public struct ScanIeMatchInfo
    {
    }


    [CppRefPath("<nn/wlan/wlan_Types.h>")]
    [ExternalStruct(21, 4)]
    [LargeData(true)]
    public struct ReceivedDataMatchInfo
    {
    }

    [CppRefPath("<nn/wlan/wlan_Types.h>")]
    [ExternalStruct(4, 4)]
    public struct WlanIpv4Address
    {
    }

    [CppRefPath("<nn/wlan/wlan_Types.h>")]
    [ExternalStruct(32, 4)]
    public struct WowlWakeCount
    {
    }

    [CppRefPath("<nn/wlan/wlan_Types.h>")]
    [ExternalStruct(56, 4)]
    public struct WowlSleepStats
    {
    }

    [CppRefPath("<nn/wlan/wlan_Types.h>")]
    [ExternalStruct(4, 4)]
    public struct ChannelStats
    {
    }

    [CppRefPath("<nn/wlan/wlan_Types.h>")]
    [ExternalStruct(8, 4)]
    [LargeData(true)]
    public struct DetectHash
    {
    }

    [CppRefPath("<nn/wlan/wlan_Types.h>")]
    [ExternalStruct(20, 4)]
    [LargeData(true)]
    public struct DetectPeriodicAfCycle
    {
    }

    [CppRefPath("<nn/wlan/wlan_Types.h>")]
    [ExternalStruct(12, 4)]
    [LargeData(true)]
    public struct DetectHeader
    {
    }

    namespace detail
    {
        public struct SfdlMacAddress
        {
            [FixedArray(6)]
            public uint8_t[] data;
        }

        public struct SfdlSsid
        {
            [FixedArray(32)]
            public Bit8[] data;
            public uint8_t length;
        }

        public struct SfdlSecurity
        {
            public uint32_t privacyMode;
            public uint32_t groupPrivacyMode;
            public uint32_t keyIdx;
            [FixedArray(65)]
            public Bit8[] key;
        }

        public struct SfdlMasterBssParameters
        {
            public uint32_t inactivePeriod;
            public uint32_t supportedRates;
            public uint32_t basicRates;
            public SfdlSecurity security;
            public SfdlSsid ssid;
            public uint16_t beaconInterval;
            public int16_t  channel;
            public bool hiddenSsid;
            public bool autoKeepAlive;
        }

        [LargeData(true)]
        public struct SfdlScanIeMatchInfo
        {
            [FixedArray(255)]
            public Bit8[] matchData;
            public uint8_t matchLength;
        }

        public struct SfdlChannelList
        {
            [FixedArray(38)]
            public int16_t[] channel;
        }

        [LargeData(true)]
        public struct SfdlScanParameters
        {
            public uint32_t scanType;
            public SfdlChannelList channelList;
            public uint8_t channelCount;
            public int32_t channelScanTime;
            public int32_t homeChannelTime;
            [FixedArray(10)]  // 暫定的に10個にしておく
            public SfdlSsid[] ssidList;
            public uint8_t ssidCount;
            public SfdlMacAddress bssid;
        }

        public struct SfdlConnectionStatus
        {
            public uint32_t state;
            public uint32_t cause;
            public int16_t  channel;
            public SfdlMacAddress bssid;
            public SfdlSsid ssid;
            public uint16_t aid;
            public uint16_t statusReasonCode;
            public uint16_t capabilityInfo;
            public uint16_t beaconInterval;
        }

        public struct SfdlClientStatus
        {
            public uint32_t state;
            public uint32_t cause;
            public SfdlMacAddress clientMacAddress;
            public uint16_t statusReasonCode;
            public uint16_t capabilityInfo;
            public int32_t rssi;
            public int64_t updateTick;
        }

        public struct SfdlDisconnectClient
        {
            public SfdlMacAddress clientMacAddress;
            public uint32_t reasonCode;
        }

        public struct SfdlMulticastFilterInfo
        {
            public uint8_t count;
            [FixedArray(8)]
            public SfdlMacAddress[] address;
        }

        [LargeData(true)]
        public struct SfdlClientStatusList
        {
            [FixedArray(7)]  // 最大接続数が7台なので
            public SfdlClientStatus[] statusList;
            public Bit32 updatedIndexBitMap;
        }

        [LargeData(true)]
        public struct SfdlBssInfo
        {
            [FixedArray(1300)]
            public Bit8[] bssinfo;
        }

        interface IInfraManager : IServiceObject
        {
            [MethodId(0)]
            Result OpenMode();

            [MethodId(1)]
            Result CloseMode();

            [MethodId(2)]
            Result GetMacAddress(Out<SfdlMacAddress> pOutMacAddr);

            [MethodId(3)]
            Result StartScan([BufferTransferMode(BufferTransferMode.MapAlias)] SfdlScanParameters scanParam);

            [MethodId(4)]
            Result StopScan();

            [MethodId(5)]
            Result Connect(SfdlSsid ssid, SfdlMacAddress bssid, int16_t channel, SfdlSecurity security, bool autoKeepAlive, int beaconLostTimeout);

            [MethodId(6)]
            Result CancelConnect();

            [MethodId(7)]
            Result Disconnect();

            [MethodId(8)]
            Result GetSystemEvent(Out<NativeHandle> pOutSystemEventReadableHandle, uint32_t type);

            [MethodId(9)]
            Result GetConnectionStatus(Out<SfdlConnectionStatus> pOutStatus);

            [MethodId(10)]
            Result GetState(Out<uint32_t> pOutState);

            [MethodId(11)]
            Result GetScanResult(OutBuffer pOutScanBuffer);

            [MethodId(12)]
            Result GetRssi(Out<int32_t> pOutRssi);

            [MethodId(13)]
            Result ChangeRxAntenna(int32_t rxAntenna);

            [MethodId(14)]
            Result GetFwVersion([BufferTransferMode(BufferTransferMode.PointerCopy)] OutBuffer pOutBuffer);

            [MethodId(15)]
            Result RequestSleep();

            [MethodId(16)]
            Result RequestWakeUp();

            [MethodId(17)]
            Result ConnectWithWps(uint32_t method, InArray<char_t> wpsPinArray, int beaconLostTimeout);

            [MethodId(18)]
            Result GetWakeupReason(Out<uint32_t> pOutReason);

            [MethodId(19)]
            Result SetTcpSessionInformation(SfdlMacAddress dstMac, WlanIpv4Address srcIp, WlanIpv4Address dstIp, uint16_t srcPort, uint16_t dstPort, uint32_t ackNum, uint16_t windowSize);

            [MethodId(20)]
            Result RemoveTcpSessionInformation();

            [MethodId(21)]
            Result GetWakeupReasonRaw(Out<uint32_t> pOutReason);

            [MethodId(22)]
            Result SetWakeupReasonRaw(uint32_t reason);

            [MethodId(23)]
            Result EnableWowlFeatures(uint32_t features);

            [MethodId(24)]
            Result GetWowlStats(Out<WowlWakeCount> pOutCounts, Out<WowlSleepStats> pOutStats);

            [MethodId(25)]
            Result ClearWowlStats(bool counts, bool stats);

            [MethodId(26)]
            Result InitializeWlanOnSkipBoot();

            [MethodId(27)]
            Result EmulateDriverInitFail();

            [MethodId(28)]
            Result GetAllowedChannels(OutArray<int16_t> outArray, Out<uint32_t> pOutCount);
        }

        interface ILocalManager : IServiceObject
        {
            [MethodId(0)]
            Result OpenMasterMode();

            [MethodId(1)]
            Result CloseMasterMode();

            [MethodId(2)]
            Result OpenClientMode();

            [MethodId(3)]
            Result CloseClientMode();

            [MethodId(4)]
            Result OpenSpectatorMode();

            [MethodId(5)]
            Result CloseSpectatorMode();

            [MethodId(6)]
            Result GetMacAddress(Out<SfdlMacAddress> pOutMacAddr);

            [MethodId(7)]
            Result CreateBss(SfdlMasterBssParameters bssParameters);

            [MethodId(8)]
            Result DestroyBss();

            [MethodId(9)]
            Result StartScan([BufferTransferMode(BufferTransferMode.MapAlias)] SfdlScanParameters scanParam);

            [MethodId(10)]
            Result StopScan();

            [MethodId(11)]
            Result Connect(SfdlSsid ssid, SfdlMacAddress bssid, int16_t channel, SfdlSecurity security, bool autoKeepAlive, uint32_t beaconInd, int beaconLostTimeout);

            [MethodId(12)]
            Result CancelConnect();

            [MethodId(13)]
            Result Join(SfdlSsid ssid, SfdlMacAddress bssid, int16_t channel, SfdlSecurity security, uint32_t beaconInd, int beaconLostTimeout);

            [MethodId(14)]
            Result CancelJoin();

            [MethodId(15)]
            Result Disconnect(uint32_t mode, SfdlDisconnectClient client);

            [MethodId(16)]
            Result SetBeaconLostCount(uint32_t count);

            [MethodId(17)]
            Result GetSystemEvent(Out<NativeHandle> pOutSystemEventReadableHandle, uint32_t type);

            [MethodId(18)]
            Result GetConnectionStatus(Out<SfdlConnectionStatus> pOutStatus);

            [MethodId(19)]
            Result GetClientStatus(
                [BufferTransferMode(BufferTransferMode.MapAlias)] Out<SfdlClientStatusList> pOutStatusList);

            [MethodId(20)]
            Result GetBssIndicationEvent(Out<NativeHandle> pOutSystemEventReadableHandle);

            [MethodId(21)]
            Result GetBssIndicationInfo(
                [BufferTransferMode(BufferTransferMode.MapAlias)] Out<SfdlBssInfo> pOutInfo);

            [MethodId(22)]
            Result GetState(Out<uint32_t> pOutState);

            [MethodId(23)]
            Result GetAllowedChannels(OutArray<int16_t> pOutArray, Out<uint32_t> pOutCount);

            [MethodId(24)]
            Result AddIe(Out<uint32_t> pOutIeIndex, uint32_t managementFrameType, InBuffer pIeBody);

            [MethodId(25)]
            Result DeleteIe(uint32_t ieIndex);

            [MethodId(26)]
            Result PutFrameRaw(InBuffer pTxData);

            [MethodId(27)]
            Result CancelGetFrame(uint32_t rxId);

            [MethodId(28)]
            Result CreateRxEntry(Out<uint32_t> pOutRxId, InArray<uint16_t> pEthertypeArray, uint32_t capacity);

            [MethodId(29)]
            Result DeleteRxEntry(uint32_t rxId);

            [MethodId(30)]
            Result AddEthertypeToRxEntry(uint32_t rxId, uint16_t ethertype);

            [MethodId(31)]
            Result DeleteEthertypeFromRxEntry(Out<uint32_t> pOutRxId, uint16_t ethertype);

            [MethodId(32)]
            Result AddMatchingDataToRxEntry(uint32_t rxId, ReceivedDataMatchInfo pMatchInfo);

            [MethodId(33)]
            Result RemoveMatchingDataFromRxEntry(uint32_t rxId, ReceivedDataMatchInfo pMatchInfo);

            [MethodId(34)]
            Result GetScanResult(OutBuffer pOutScanBuffer, ScanIeMatchInfo ieInfo);

            [MethodId(35)]
            Result PutActionFrameOneShot(SfdlMacAddress macAddr, InBuffer pTxData, uint32_t channel, uint32_t dwellTime);

            [MethodId(36)]
            Result SetActionFrameWithBeacon(InBuffer pTxData);

            [MethodId(37)]
            Result CancelActionFrameWithBeacon();

            [MethodId(38)]
            Result CreateRxEntryForActionFrame(Out<uint32_t> pOutRxId, InArray<uint16_t> pSubtypeArray, uint32_t capacity);

            [MethodId(39)]
            Result DeleteRxEntryForActionFrame(uint32_t rxId);

            [MethodId(40)]
            Result AddSubtypeToRxEntryForActionFrame(uint32_t rxId, uint32_t type);

            [MethodId(41)]
            Result DeleteSubtypeFromRxEntryForActionFrame(Out<uint32_t> pOutRxId, uint32_t type);

            [MethodId(42)]
            Result CancelGetActionFrame(uint32_t rxId);

            [MethodId(43)]
            Result GetRssi(Out<int32_t> pOutRssi);

            [MethodId(44)]
            Result SetMaxAssociationNumber(uint32_t maxNum);

            [MethodId(45)]
            Result OpenLcsMasterMode();

            [MethodId(46)]
            Result CloseLcsMasterMode();

            [MethodId(47)]
            Result OpenLcsClientMode();

            [MethodId(48)]
            Result CloseLcsClientMode();

            [MethodId(49)]
            Result GetChannelStats(OutArray<ChannelStats> outStats, Out<uint32_t> pOutCount);
        }

        interface ISocketManager : IServiceObject
        {
            [MethodId(0)]
            Result PutFrameRaw(InBuffer pTxData);

            [MethodId(1)]
            Result CancelGetFrame(uint32_t rxId);

            [MethodId(2)]
            Result CreateRxEntry(Out<uint32_t> pOutRxId, InArray<uint16_t> pEthertypeArray, uint32_t capacity);

            [MethodId(3)]
            Result DeleteRxEntry(uint32_t rxId);

            [MethodId(4)]
            Result AddEthertypeToRxEntry(uint32_t rxId, uint16_t ethertype);

            [MethodId(5)]
            Result DeleteEthertypeFromRxEntry(Out<uint32_t> pOutRxId, uint16_t ethertype);

            [MethodId(6)]
            Result GetMacAddress(Out<SfdlMacAddress> pOutMacAddr);

            [MethodId(7)]
            Result SwitchTsfTimerFunction(bool enable);

            [MethodId(8)]
            Result GetDeltaTimeBetweenSystemAndTsf(Out<int64_t> pOutDeltaTime);

            [MethodId(9)]
            Result RegisterSharedMemory(NativeHandle memHandle, uint32_t memSize, NativeHandle RxEventHandle, NativeHandle TxEventHandle, NativeHandle RxCbufEventHandle, NativeHandle TxCbufEventHandlw);

            [MethodId(10)]
            Result UnregisterSharedMemory();

            [MethodId(11)]
            Result EnableSharedMemory();

            [MethodId(12)]
            Result SetMulticastFilter(SfdlMulticastFilterInfo info);
        }

        interface ILocalGetFrame : IServiceObject
        {
            [MethodId(0)]
            Result GetFrameRaw(OutBuffer pOutRxData, Out<uint32_t> pOutSize, uint32_t rxId);
        }

        interface ILocalGetActionFrame : IServiceObject
        {
            [MethodId(0)]
            Result GetActionFrameCore(Out<SfdlMacAddress> pOutMacAddr, OutBuffer pOutRxData, Out<uint32_t> pOutSize, uint32_t rxId, Out<uint16_t> pOutChannel, Out<int16_t> pOutRssi, bool isEx);
        }

        interface ISocketGetFrame : IServiceObject
        {
            [MethodId(0)]
            Result GetFrameRaw(OutBuffer pOutRxData, Out<uint32_t> pOutSize, uint32_t rxId);
        }

        interface IDetectManager : IServiceObject
        {
            [MethodId(0)]
            Result OpenMode();

            [MethodId(1)]
            Result OpenModeWithChannel(uint16_t channel);

            [MethodId(2)]
            Result CloseMode();

            [MethodId(3)]
            Result GetMacAddress(Out<SfdlMacAddress> pOutMacAddr);

            [MethodId(4)]
            Result GetState(Out<uint32_t> pOutState);

            [MethodId(5)]
            Result PutActionFrameOneShot(SfdlMacAddress macAddr, uint8_t subtype, DetectHash hash, InBuffer pTxData, uint32_t dwellTime);

            [MethodId(6)]
            Result StartPeriodicActionFrame(uint8_t subtype, DetectHash hash, InBuffer pTxData, uint32_t interval);

            [MethodId(7)]
            Result CancelPeriodicActionFrame();

            [MethodId(8)]
            Result GetActionFrame(Out<SfdlMacAddress> pOutMacAddr, OutBuffer pOutRxData, Out<uint32_t> pOutSize, uint32_t rxId, Out<uint16_t> pOutChannel, Out<int16_t> pOutRssi, Out<int64_t> pOutTick);

            [MethodId(9)]
            Result CancelGetActionFrame(uint32_t rxId);

            [MethodId(10)]
            Result CreateRxEntryForActionFrame(Out<uint32_t> pOutRxId, InArray<uint16_t> pSubtypeArray, uint32_t capacity);

            [MethodId(11)]
            Result DeleteRxEntryForActionFrame(uint32_t rxId);

            [MethodId(12)]
            Result AddSubtypeToRxEntryForActionFrame(uint32_t rxId, uint32_t type);

            [MethodId(13)]
            Result DeleteSubtypeFromRxEntryForActionFrame(Out<uint32_t> pOutRxId, uint32_t type);

            [MethodId(14)]
            Result ReserveDetectSleep();

            [MethodId(15)]
            Result CancelDetectSleep();

            [MethodId(16)]
            Result SetActionFrameForSleep(uint8_t subtype, DetectHash hash, InBuffer pTxData);

            [MethodId(17)]
            Result SetHashList(InBuffer pHashList);

            [MethodId(18)]
            Result SetPeriodicActionFrameCycle(DetectPeriodicAfCycle pattern, uint8_t target);

            [MethodId(19)]
            Result RequestSleep();

            [MethodId(20)]
            Result RequestWakeUp();

            [MethodId(21)]
            Result PutActionFrameOneShotEx(SfdlMacAddress macAddr, SfdlMacAddress bssid, uint8_t subtype, DetectHeader dhp, InBuffer pTxData, uint32_t dwellTime);

            [MethodId(22)]
            Result StartCommunication();

            [MethodId(23)]
            Result StopCommunication();

            [MethodId(24)]
            Result SetMacAddress(SfdlMacAddress macAddr);

            [MethodId(25)]
            Result GetAllowedChannels(OutArray<int16_t> outArray, Out<uint32_t> pOutCount);

            [MethodId(26)]
            Result GetTotalRecvCountInSleep(Out<uint64_t> pOutCount);

            [MethodId(27)]
            Result ClearTotalRecvCountInSleep();
        }

    }
}
