﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "visrv_Strategy.h"

namespace nn { namespace visrv { namespace settings {

    Strategy ConvertStrategy(std::underlying_type<Strategy>::type value) NN_NOEXCEPT
    {
#define CASE(x) case Strategy::x: return Strategy::x
        switch( static_cast<Strategy>(value) )
        {
            CASE(HighestPriority);
            CASE(PriorityFallback);
        default:
            NN_UNEXPECTED_DEFAULT;
        }
#undef CASE
    }

}}}
