﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "visrv_InterfaceType.h"

namespace nn { namespace visrv { namespace settings {

    InterfaceType ConvertInterface(std::underlying_type<InterfaceType>::type value) NN_NOEXCEPT
    {
#define CASE(x) case InterfaceType::x: return InterfaceType::x
        switch( static_cast<InterfaceType>(value) )
        {
            CASE(Null);
            CASE(Dsi);
            CASE(Hdmi);
            CASE(DisplayPort);
        default:
            NN_UNEXPECTED_DEFAULT;
        }
#undef CASE
    }

}}}
