﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/vi/sf/hosbinder_IHOSBinderDriver.sfdl.h>
#include "../client/visrv_ClientObject.h"

namespace nn{ namespace visrv{ namespace service{

    class IndirectDisplayTransactionServiceImpl
    {
    public:
        NN_IMPLICIT IndirectDisplayTransactionServiceImpl(client::ClientObjectSmartHolder* pClientHolder) NN_NOEXCEPT;
        ~IndirectDisplayTransactionServiceImpl() NN_NOEXCEPT;

        // older version to HR19.x / must be supported
        void TransactParcel(
            std::int32_t handle,
            std::uint32_t code,
            const nn::sf::InBuffer& requestBuffer,
            const nn::sf::OutBuffer& replyBuffer,
            std::uint32_t flags
            ) NN_NOEXCEPT;

        // new version from HR19.x
        void TransactParcelAuto(
            std::int32_t handle,
            std::uint32_t code,
            const nn::sf::InBuffer& requestBuffer,
            const nn::sf::OutBuffer& replyBuffer,
            std::uint32_t flags
            ) NN_NOEXCEPT;

        void AdjustRefcount(
            std::int32_t handle,
            std::int32_t diff,
            std::int32_t isStrong
            ) NN_NOEXCEPT;

        void GetNativeHandle(
            std::int32_t handle,
            std::uint32_t code,
            nn::sf::Out<nn::sf::NativeHandle> result
            ) NN_NOEXCEPT;

    private:
        client::ClientObjectSmartHolder m_ClientHolder;
    };

}}}
