﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/vi/sf/vi_DisplayService.sfdl.h>
#include <nn/vi/sf/vi_PolicyLevel.h>

#include "../client/visrv_ClientObject.h"

namespace nn{ namespace visrv{ namespace service{

    class ApplicationDisplayServiceImpl
    {
    public:
        NN_IMPLICIT ApplicationDisplayServiceImpl(const client::ClientConstants& clientConstants) NN_NOEXCEPT;
        ~ApplicationDisplayServiceImpl() NN_NOEXCEPT;

        nn::Result GetRelayService(
            nn::sf::Out<nn::sf::SharedPointer<nns::hosbinder::IHOSBinderDriver>> outRelayService
            ) NN_NOEXCEPT;

        nn::Result GetSystemDisplayService(
            nn::sf::Out<nn::sf::SharedPointer<nn::visrv::sf::ISystemDisplayService>> outSystemService
            ) NN_NOEXCEPT;

        nn::Result GetManagerDisplayService(
            nn::sf::Out<nn::sf::SharedPointer<nn::visrv::sf::IManagerDisplayService>> outManagerService
            ) NN_NOEXCEPT;

        nn::Result GetIndirectDisplayTransactionService(
            nn::sf::Out<nn::sf::SharedPointer<nns::hosbinder::IHOSBinderDriver>> outService
            ) NN_NOEXCEPT;

        nn::Result ListDisplays(
            nn::sf::Out<std::int64_t> outCount,
            const nn::sf::OutArray<nn::vi::DisplayInfo>& outInfo
            ) NN_NOEXCEPT;

        nn::Result OpenDisplay(
            nn::sf::Out<nn::vi::DisplayId> outDisplayId,
            const nn::vi::DisplayName& name
            ) NN_NOEXCEPT;

        nn::Result OpenDefaultDisplay(
            nn::sf::Out<nn::vi::DisplayId> outDisplayId
            ) NN_NOEXCEPT;

        nn::Result CloseDisplay(
            nn::vi::DisplayId displayId
            ) NN_NOEXCEPT;

        nn::Result SetDisplayEnabled(
            nn::vi::DisplayId displayId,
            bool isEnabled
            ) NN_NOEXCEPT;

        nn::Result GetDisplayResolution(
            nn::sf::Out<std::int64_t> outWidth,
            nn::sf::Out<std::int64_t> outHeight,
            nn::vi::DisplayId displayId
            ) NN_NOEXCEPT;

        nn::Result OpenLayer(
            nn::sf::Out<std::int64_t> outNativeWindowDataSize,
            const nn::sf::OutBuffer& outNativeWindowData,
            nn::vi::LayerId layerId,
            nn::vi::DisplayName displayName,
            nn::applet::AppletResourceUserId aruid
            ) NN_NOEXCEPT;

        nn::Result CloseLayer(
            nn::vi::LayerId layerId
            ) NN_NOEXCEPT;

        nn::Result CreateStrayLayer(
            nn::sf::Out<nn::vi::LayerId> outLayerId,
            nn::sf::Out<std::int64_t> outNativeWindowDataSize,
            const nn::sf::OutBuffer& outNativeWindowData,
            nn::vi::DisplayId displayId,
            nn::vi::LayerSettingsType settings
            ) NN_NOEXCEPT;

        nn::Result DestroyStrayLayer(
            nn::vi::LayerId layerId
            ) NN_NOEXCEPT;

        nn::Result SetLayerScalingMode(
            nn::vi::LayerId layerId,
            nn::vi::ScalingModeType mode
            ) NN_NOEXCEPT;

        nn::Result ConvertScalingMode(
            nn::sf::Out<std::int64_t> outMode,
            nn::vi::ScalingModeType viMode
            ) NN_NOEXCEPT;

        // old
        nn::Result GetIndirectLayerImageMap(
            nn::sf::Out<std::int64_t> outSize,
            nn::sf::Out<std::int64_t> outStride,
            const nn::sf::OutBuffer& outBuffer,
            std::int64_t width,
            std::int64_t height,
            nn::vi::IndirectConsumerHandleType consumerHandle,
            nn::applet::AppletResourceUserId aruid
            ) NN_NOEXCEPT;

        nn::Result GetIndirectLayerImageCropMap(
            nn::sf::Out<std::int64_t> outSize,
            nn::sf::Out<std::int64_t> outStride,
            const nn::sf::OutBuffer& outBuffer,
            std::int64_t width,
            std::int64_t height,
            float sourceRectX,
            float sourceRectY,
            float sourceRectWidth,
            float sourceRectHeight,
            nn::vi::IndirectConsumerHandleType consumerHandle,
            nn::applet::AppletResourceUserId aruid
            ) NN_NOEXCEPT;


        nn::Result GetIndirectLayerImageRequiredMemoryInfo(
            nn::sf::Out<std::int64_t> outSize,
            nn::sf::Out<std::int64_t> outAlignment,
            std::int64_t width,
            std::int64_t height
            ) NN_NOEXCEPT;

        nn::Result OpenIndirectImageTransfer(
            nn::sf::Out<nn::sf::NativeHandle> outIsImageReadyEventHandle,
            nn::sf::NativeHandle&& bufferHandle,
            std::uint64_t bufferSize,
            std::int64_t width,
            std::int64_t height,
            nn::vi::IndirectConsumerHandleType consumerHandle,
            nn::applet::AppletResourceUserId aruid
            ) NN_NOEXCEPT;

        nn::Result CloseIndirectImageTransfer(nn::vi::IndirectConsumerHandleType consumerHandle) NN_NOEXCEPT;

        nn::Result UpdateIndirectImageTransfer(
            nn::sf::Out<std::int64_t> outSize,
            nn::sf::Out<std::int64_t> outStride,
            nn::vi::IndirectConsumerHandleType consumerHandle,
            float sourceRectX,
            float sourceRectY,
            float sourceRectWidth,
            float sourceRectHeight
            ) NN_NOEXCEPT;

        nn::Result GetDisplayVsyncEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::vi::DisplayId displayId) NN_NOEXCEPT;
        nn::Result GetDisplayVsyncEventForDebug(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::vi::DisplayId displayId) NN_NOEXCEPT;

        client::ClientObject* GetClient() NN_NOEXCEPT;

    private:
        client::ClientObjectSmartHolder m_ClientHolder;

        // settings flags applications are allowed to change
        static const nn::vi::LayerSettingsType LayerSettingsProtectedMask = 0xFFFFFFFF;
    };

}}}
