﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "visrv_ActiveDisplay.h"
#include "visrv_Display.h"

namespace
{
    nn::visrv::master::Display* g_pActiveDisplay = nullptr;
}

namespace nn{ namespace visrv{ namespace master{

    void SetActiveDisplay(Display* pDisplay) NN_NOEXCEPT
    {
        NN_SDK_ASSERT_NOT_NULL(pDisplay);

        // open next default display first in case g_pActiveDisplay == pDisplay
        pDisplay->Open();

        if( g_pActiveDisplay != nullptr )
        {
            g_pActiveDisplay->Close();
        }

        g_pActiveDisplay = pDisplay;
    }

    Display* GetActiveDisplay() NN_NOEXCEPT
    {
        return g_pActiveDisplay;
    }

}}}
