﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "../../visrv_Config.h"
#include "visrv_IModeFilter.h"

namespace nn { namespace vi {
    struct DisplayModeInfoInternal;
}}

namespace nn { namespace visrv { namespace master{ namespace detail {

    class WhiteListFilter : public IModeFilter
    {
    public:
        WhiteListFilter() NN_NOEXCEPT;
        void Initialize(const nn::vi::DisplayModeInfoInternal* pValidModes, int validModeCountMax) NN_NOEXCEPT;

        virtual bool IsValid(const nn::vi::DisplayModeInfoInternal& pMode) const NN_NOEXCEPT;
    private:
        const nn::vi::DisplayModeInfoInternal* m_pValidModes;
        int m_ValidModeCountMax;
    };

}}}}
