﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstring>
#include <cmath>
#include <nn/vi/vi_DisplayModeInfoInternal.h>
#include "visrv_WhitelistFilter.h"

namespace nn{ namespace visrv{ namespace master{ namespace detail{

    WhiteListFilter::WhiteListFilter() NN_NOEXCEPT
        : m_pValidModes(nullptr)
        , m_ValidModeCountMax(0)
    {
    }

    void WhiteListFilter::Initialize(const nn::vi::DisplayModeInfoInternal* pValidModes, int validModeCountMax) NN_NOEXCEPT
    {
        m_pValidModes = pValidModes;
        m_ValidModeCountMax = validModeCountMax;
    }

    bool WhiteListFilter::IsValid(const nn::vi::DisplayModeInfoInternal& pMode) const NN_NOEXCEPT
    {
        for( int i = 0; i < m_ValidModeCountMax; ++i )
        {
            if( m_pValidModes[i].clientInfo.width == pMode.clientInfo.width &&
                m_pValidModes[i].clientInfo.height == pMode.clientInfo.height &&
                m_pValidModes[i].clientInfo.mode == pMode.clientInfo.mode &&
                m_pValidModes[i].ratio == pMode.ratio )
            {
                float error = std::abs(m_pValidModes[i].clientInfo.refreshRate - pMode.clientInfo.refreshRate);

                if( error <= 0.001f )
                {
                    return true;
                }
            }
        }

        return false;
    }
}}}}
