﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_SdkAssert.h>
#include "visrv_SingleDisplayStrategy.h"

namespace nn { namespace visrv { namespace master { namespace detail {

    SingleDisplayStrategy::SingleDisplayStrategy() NN_NOEXCEPT
        : m_pDisplay(nullptr)
    {
    }

    SingleDisplayStrategy::SingleDisplayStrategy(IPhysicalDisplay* pDisplay) NN_NOEXCEPT
        : m_pDisplay(pDisplay)
    {
        NN_SDK_ASSERT_NOT_NULL(m_pDisplay);
    }

    void SingleDisplayStrategy::Initialize(IPhysicalDisplay* pDisplay) NN_NOEXCEPT
    {
        NN_SDK_ASSERT_NOT_NULL(pDisplay);
        m_pDisplay = pDisplay;
    }

    IPhysicalDisplay* SingleDisplayStrategy::GetDisplay() NN_NOEXCEPT
    {
        NN_SDK_ASSERT_NOT_NULL(m_pDisplay);
        return m_pDisplay;
    }

    nn::Result SingleDisplayStrategy::Visit(DisplayVisitor visitor, void* userData) NN_NOEXCEPT
    {
        NN_SDK_ASSERT_NOT_NULL(visitor);
        return visitor(m_pDisplay, userData);
    }

}}}}
