﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "visrv_PlatformDisplayInfoSet.h"

#include <nn/nn_SdkAssert.h>

namespace nn{ namespace visrv{ namespace master{ namespace detail{

    const PlatformDisplayInfo& PlatformDisplayInfoSet::GetInfo(nn::vi::PolicyLevelType policyLevel) const NN_NOEXCEPT
    {
        NN_SDK_REQUIRES_RANGE(policyLevel, 0, nn::vi::PolicyLevelCount);
        return m_InfoList[policyLevel];
    }

    void PlatformDisplayInfoSet::SetInfo(nn::vi::PolicyLevelType policyLevel, const PlatformDisplayInfo& info) NN_NOEXCEPT
    {
        NN_SDK_REQUIRES_RANGE(policyLevel, 0, nn::vi::PolicyLevelCount);
        m_InfoList[policyLevel] = info;
    }

}}}}
