﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/TargetConfigs/build_Base.h>
#include <nn/vi/sf/vi_PolicyLevel.h>
#include "visrv_DisplayManager.h"
#include "visrv_PlatformDisplayInfo.h"
#include "visrv_PlatformDisplayDefines.h"

namespace nn{ namespace visrv{ namespace master{ namespace detail{

    // Note: This can be useful for debugging segment sizes:
    //       Print<sizeof(g_Padding)>() will print a compile error with the evaluated expression.
    //template <size_t i>
    //class Print;

    // TODO: Find an appropriate size
    const size_t StorageMax    = 16384;
    // Storage size for any global variables
    const size_t GlobalStorage = sizeof(DisplayManager*);

    typedef nn::util::TypedStorage<DisplayManager,
                                   sizeof(DisplayManager),
                                   NN_ALIGNOF(DisplayManager)>
            DisplayManagerStorageType;
    extern DisplayManagerStorageType g_DisplayManagerStorage;

    // Maximum memory (in bytes) for named displays
    const size_t DisplayInfoSegmentSize = PlatformDisplayCount * sizeof(PlatformDisplayInfo);
    // Maximum memory (in bytes) for open displays
    const size_t DisplaySegmentSize     = 1024 * 8;
    // Maximum memory (in bytes) for layers created by the process
    const size_t LayerSegmentSize       = 1024;

    extern int  g_DisplayInfoSegmentCount[nn::vi::PolicyLevelCount];
    extern char g_DisplayInfoSegment[nn::vi::PolicyLevelCount][DisplayInfoSegmentSize];
    extern char g_DisplaySegment[DisplaySegmentSize];
    extern char g_LayerSegment[LayerSegmentSize];

}}}}

#if defined(NN_BUILD_CONFIG_OS_WIN)
    #include "visrv_MemoryMap-os.win32.h"
#elif defined(NN_BUILD_CONFIG_OS_HORIZON)
    #include "visrv_MemoryMap-os.horizon.h"
#endif
