﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "visrv_LocalApi.h"

#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>
#include "visrv_LocalServerObject.h"
#include "../fbshare/visrv_SharingServerObject.h"

namespace nn{ namespace visrv{ namespace local{

    void EnqueueLocalRequestAsync(void (*function)(void*), void* userPtr) NN_NOEXCEPT
    {
        // NOTE: vi_Main の実装上、各スレッドが動き出すのは一通り初期化が終わってからなので初期化待ちはしなくて良い。
        g_LocalRequestQueue.EnqueueAsync(function, userPtr);
    }

    nn::Result EnqueueLocalRequestSync(nn::Result (*function)(void*), void* userPtr) NN_NOEXCEPT
    {
        struct Argument
        {
            nn::Result (*function)(void*);
            void* userPtr;

            nn::os::EventType completeEvent;
            nn::Result outResult;
        };

        auto functionWrapper = [](void* p) -> void
        {
            auto pArg = reinterpret_cast<Argument*>(p);
            pArg->outResult = pArg->function(pArg->userPtr);
            nn::os::SignalEvent(&pArg->completeEvent);
        };

        Argument arg = {};
        arg.function = function;
        arg.userPtr = userPtr;
        nn::os::InitializeEvent(&arg.completeEvent, false, nn::os::EventClearMode_ManualClear);
        NN_UTIL_SCOPE_EXIT{ nn::os::FinalizeEvent(&arg.completeEvent); };

        EnqueueLocalRequestAsync(functionWrapper, &arg);

        nn::os::WaitEvent(&arg.completeEvent);
        return arg.outResult;
    }

    //--------------------------------------

    nn::Result GetSharedMemoryPoolInfo(
        NvRmMemHandle* pOutMemHandle,
        void** pOutMemory,
        size_t* pOutMemorySize,
        nn::vi::fbshare::SharedMemoryPoolLayout* pOutLayout,
        nn::vi::fbshare::SharedBufferHandle hBuffer
    ) NN_NOEXCEPT
    {
        nn::visrv::fbshare::SharedBuffer* pBuffer = nullptr;
        NN_RESULT_DO(nn::visrv::fbshare::g_SharedBufferPool.Find(&pBuffer, hBuffer));

        pBuffer->GetSharedMemoryPoolInfo(pOutMemHandle, pOutMemory, pOutMemorySize, pOutLayout);
        NN_RESULT_SUCCESS;
    }

}}}
