﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#include "visrv_IndirectDisplay.h"
#include <binder/Binder.h>

namespace nn{ namespace visrv{ namespace indirect{

    struct IndirectProducerBinderTableEntry
    {
        IndirectLayer* pLayer;
    };

    class IndirectProducerBinderTable
    {
    public:
        static const int Size = IndirectLayerCountPerClientMax;
    public:
        IndirectProducerBinderTable() NN_NOEXCEPT;

        nn::Result Register(int* pOutEntryIndex, IndirectLayer* pLayer) NN_NOEXCEPT;
        void Unregister(int entryIndex) NN_NOEXCEPT;

        const IndirectProducerBinderTableEntry& Get(int entryIndex) NN_NOEXCEPT;
        nn::Result Find(int* pOutEntryIndex, const IndirectLayer* pLayer) const NN_NOEXCEPT;

    private:
        IndirectProducerBinderTableEntry m_EntryList[Size];
    };

}}}
