﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/os/os_TransferMemoryTypes.h>
#include "../vic/visrv_VicTaskQueue.h"
#include "../vic/visrv_VicMemoryPool.h"
#include "../vic/visrv_VicImageBuffer.h"
#include <nvrm_channel.h>
#include <ui/GraphicBuffer.h>

namespace nn{ namespace visrv{ namespace indirect{

    class IndirectLayer;
    class IndirectLayerBufferStage;
    class IndirectLockCounter;

    struct IndirectTransferCopyImageParameter
    {
    public:
        void SetDefault() NN_NOEXCEPT
        {
            this->sourceRectX = 0;
            this->sourceRectY = 0;
            this->sourceRectWidth  = 1;
            this->sourceRectHeight = 1;
            this->pSourceBufferStage = nullptr;
            this->pSourceBufferLockCounter = nullptr;
            this->pSourceGraphicBuffer.clear();
        }
    public:
        float sourceRectX;
        float sourceRectY;
        float sourceRectWidth;
        float sourceRectHeight;

        IndirectLayerBufferStage* pSourceBufferStage;
        IndirectLockCounter*      pSourceBufferLockCounter;
        android::sp<android::GraphicBuffer> pSourceGraphicBuffer;

        IndirectLockCounter*      pDestinationBoundLockCounter;
    };

    class IndirectConsumerBindExStateTransfer
        : public vic::IVicTask
    {
    public:
        typedef IndirectTransferCopyImageParameter Parameter;
    public:
        IndirectConsumerBindExStateTransfer() NN_NOEXCEPT;

        nn::Result Initialize(
            nn::os::NativeHandle* pOutIsBufferReadyEventHandle,
            bool* pOutIsBufferReadyEventHandleManaged,
            nn::os::NativeHandle bufferTransferMemoryHandle,
            bool* pIsBufferTransferMemoryHandleManaged,
            size_t bufferTransferMemorySize,
            int width,
            int height
            ) NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;

        void SetParameter(const Parameter& param) NN_NOEXCEPT;
        void SignalIsBufferReadySystemEvent() NN_NOEXCEPT;
        void ClearIsBufferReadySystemEvent() NN_NOEXCEPT;

        size_t GetImageSize() const NN_NOEXCEPT;
        size_t GetImageStride() const NN_NOEXCEPT;

        virtual void Execute() NN_NOEXCEPT NN_OVERRIDE;


    private:
        nn::os::SystemEventType    m_IsBufferReadySystemEvent;
        nn::os::TransferMemoryType m_BufferTransferMemory;
        void*                      m_pBufferMemory;
        size_t                     m_BufferMemorySize;
        vic::VicMemoryPool         m_MemoryPool;
        vic::VicImageBuffer        m_ImageBuffer;

        Parameter                  m_Parameter;
    };

}}}
