﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "visrv_SharedBufferStaticStorage.h"

#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>
#include <nn/vi/vi_Result.h>

namespace nn{ namespace visrv{ namespace fbshare{

    namespace {

        NN_ALIGNAS(4096) union
        {
            #define static
            #include "../../../Processes/am/am_StartupLogoImage.h"
            #undef static
            char storage[SharedBufferStaticStorage::Size];
        } g_Storage;

        NN_STATIC_ASSERT(sizeof(g_Storage) >= SharedBufferStaticStorageSize);
        NN_STATIC_ASSERT(sizeof(g_Storage) >= nn::am::service::display::StartupLogoSize);
    }

    const size_t SharedBufferStaticStorage::Size;

    SharedBufferStaticStorage::SharedBufferStaticStorage() NN_NOEXCEPT
        : m_State(SharedBufferStaticStorageState_Free)
    {
    }

    bool SharedBufferStaticStorage::IsUsed(uint64_t key) const NN_NOEXCEPT
    {
        NN_UNUSED(key);
        return m_State == SharedBufferStaticStorageState_Used;
    }

    nn::Result SharedBufferStaticStorage::AcquireStorage(void** pOutMemory, size_t* pOutSize, uint64_t key) NN_NOEXCEPT
    {
        NN_RESULT_THROW_UNLESS(!IsUsed(key), nn::vi::ResultResourceLimit());

        *pOutMemory = g_Storage.storage;
        *pOutSize   = Size;
        NN_RESULT_SUCCESS;
    }

    void SharedBufferStaticStorage::ReleaseStorage(void* pMemory, size_t size) NN_NOEXCEPT
    {
        //NN_SDK_REQUIRES(IsUsed(key));
        NN_SDK_REQUIRES_EQUAL(pMemory, static_cast<void*>(g_Storage.storage));
        //NN_SDK_REQUIRES_EQUAL(size, Size);

        m_State = SharedBufferStaticStorageState_Free;
    }

}}}
