﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nvrm_init.h>

namespace nn{ namespace visrv{ namespace fbshare{

    // @brief RmDevice for fbshare
    // @details
    // RmDeviceHandle will be a same value in a process.
    class Device
    {
    public:
        Device() NN_NOEXCEPT;

        void Initialize() NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;

        NvRmDeviceHandle Get() const NN_NOEXCEPT;

    private:
        NvRmDeviceHandle m_hDevice;
    };

}}}

