﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include "../visrv_Config.h"
#include "visrv_ClientLayerHolder.h"

namespace nn{ namespace visrv{ namespace client{

    class LayerPool
    {
    public:
        static const int LayerSlotCount = LayerCountPerDisplayMax * DisplayCountPerClientMax * ClientProcessCountMax;
        typedef ClientLayerHolder value_type;
        typedef value_type&       reference;
        typedef value_type*       iterator;

    public:
        void Initialize() NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;

        iterator begin() NN_NOEXCEPT;
        iterator end() NN_NOEXCEPT;

    private:
        value_type m_Pool[LayerSlotCount];
    };

    // TORIAEZU: ServerManager と一緒に初期化／破棄される
    extern LayerPool g_LayerPool;

}}}

