﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/vi/sf/vi_ServiceTypes.h>
#include <nn/vi/sf/vi_PolicyLevel.h>

namespace nn{ namespace visrv{ namespace client{

    enum ClientPermission
    {
        ClientPermission_Application,
        ClientPermission_System,
        ClientPermission_Manager,
    };

    class ClientConstants
    {
    public:
        ClientConstants(
            ClientPermission permission,
            nn::vi::PolicyLevelType policyLevel,
            bool isProxyNameExchangeEnabled,
            const nn::vi::ProxyName& exchangeProxyName
        ) NN_NOEXCEPT
            : m_Permission(permission)
            , m_PolicyLevel(policyLevel)
            , m_IsProxyNameExchangeEnabled(isProxyNameExchangeEnabled)
            , m_ExchangeProxyName(exchangeProxyName)
        {
        }

        ClientPermission GetPermission() const
        {
            return m_Permission;
        }

        nn::vi::PolicyLevelType GetPolicyLevel() const
        {
            return m_PolicyLevel;
        }

        bool IsProxyNameExchangeEnabled() const
        {
            return m_IsProxyNameExchangeEnabled;
        }

        const nn::vi::ProxyName& GetExchangeProxyName() const
        {
            return m_ExchangeProxyName;
        }

    private:
        ClientPermission             m_Permission;
        nn::vi::PolicyLevelType      m_PolicyLevel;
        bool                         m_IsProxyNameExchangeEnabled;
        nn::vi::ProxyName            m_ExchangeProxyName;
    };

}}}
