﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <atomic>
#include <memory>
#include <nn/nn_Macro.h>
#include <nn/os.h>
#include "vi_Windows.h"

namespace nn { namespace vi { namespace detail {

    class VsyncManager
    {
    public:
        VsyncManager() NN_NOEXCEPT;
        ~VsyncManager() NN_NOEXCEPT;

        nn::os::NativeHandle GetClientReadableHandle() NN_NOEXCEPT;
    private:
        HANDLE m_VsyncThread;
        bool m_IsAvailable;

        class ReleaseDeleter
        {
        public:
            template <typename T>
            void operator()(T* ptr) const NN_NOEXCEPT
            {
                if( ptr )
                {
                    ptr->Release();
                }
            }
        };

        template <typename T>
        using DxgiPtr = std::unique_ptr<T, ReleaseDeleter>;

        DxgiPtr<IDXGIFactory> m_Factory;

        class VsyncThreadArgs
        {
        public:
            VsyncThreadArgs() NN_NOEXCEPT;

            nn::os::SystemEvent vsyncEvent;
            DxgiPtr<IDXGIOutput> pOutput;
            std::atomic<bool> isRunning;
        };

        VsyncThreadArgs m_Args;

        static DWORD WINAPI VsyncThread(void* ptr) NN_NOEXCEPT;

        static DxgiPtr<IDXGIOutput> GetPrimaryOutput(DxgiPtr<IDXGIFactory>& pFactory) NN_NOEXCEPT;
        static void FakeVsync(nn::os::SystemEvent* pVsync, const std::atomic<bool>& isRunning, DxgiPtr<IDXGIOutput>& pOutput) NN_NOEXCEPT;
        static void RealVsync(nn::os::SystemEvent* pVsync, const std::atomic<bool>& isRunning, DxgiPtr<IDXGIOutput>& pOutput) NN_NOEXCEPT;
    };

}}}
