﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/vi/vi_PixelFormat.h>
#include <nn/vi/vi_ScalingMode.h>

namespace nn { namespace vi { namespace detail {

    class PlatformDisplayInfo;

    int SetupStandardPolicy(PlatformDisplayInfo* pOutDisplays, int displayCountMax);
    int SetupCompositionPolicy(PlatformDisplayInfo* pOutDisplays, int displayCountMax);

    bool PixelFormatSupport(nn::vi::PixelFormat format) NN_NOEXCEPT;
    bool ScalingModeSupport(nn::vi::ScalingMode mode) NN_NOEXCEPT;

}}}
