﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/vi/vi_DisplayModeInfo.h>
#include <nn/vi/vi_Result.h>
#include "vi_DefaultDisplay-spec.NX.h"
#include "vi_WhitelistFilter.h"

nn::vi::detail::DefaultDisplay::DefaultDisplay(const detail::PlatformDisplayInfo& info, Display::Allocator* pAllocator, const IModeFilter* pFilter, IPhysicalDisplay* pInternal, IPhysicalDisplay* pExternal) NN_NOEXCEPT
    : Display(info, pAllocator, pFilter)
    , m_Lcd(pInternal)
    , m_Hdmi(pExternal)
{
}

nn::vi::detail::DefaultDisplay::~DefaultDisplay() NN_NOEXCEPT
{
    m_Lcd->Close();
    m_Hdmi->Close();
}

nn::Result nn::vi::detail::DefaultDisplay::Initialize() NN_NOEXCEPT
{
    if( m_Lcd->Open().IsFailure() )
    {
        return nn::vi::ResultOperationFailed();
    }

    if( m_Hdmi->Open().IsFailure() )
    {
        return nn::vi::ResultOperationFailed();
    }

    return nn::ResultSuccess();
}

nn::Result nn::vi::detail::DefaultDisplay::GetHotplugState(HotplugState* pOutState) const NN_NOEXCEPT
{
    return m_Hdmi->GetHotplugState(pOutState);
}

int nn::vi::detail::DefaultDisplay::ListModes(DisplayModeInfo* pOutModes, int modeCountMax, const IModeFilter* pFilter) const NN_NOEXCEPT
{
    return GetCurrentDisplay()->ListModes(pOutModes, modeCountMax, pFilter);
}

nn::Result nn::vi::detail::DefaultDisplay::GetMode(DisplayModeInfo* pOutMode) const NN_NOEXCEPT
{
    // This API is also used by GetResolution.  When using HdmiDisplay, this could result in
    // ResultDisplayDisconnected in the case of failure.  This isn't an error code applications
    // need to support in this case.
    if( GetCurrentDisplay()->GetMode(pOutMode).IsSuccess() )
    {
        return nn::ResultSuccess();
    }

    return nn::vi::ResultOperationFailed();
}

nn::Result nn::vi::detail::DefaultDisplay::SetMode(const DisplayModeInfo* pMode, const IModeFilter* pFilter) NN_NOEXCEPT
{
    return GetCurrentDisplay()->SetMode(pMode, pFilter);
}

int nn::vi::detail::DefaultDisplay::ListRgbRanges(RgbRange* pOutRanges, int rgbRangeCountMax) const NN_NOEXCEPT
{
    return GetCurrentDisplay()->ListRgbRanges(pOutRanges, rgbRangeCountMax);
}

nn::Result nn::vi::detail::DefaultDisplay::GetRgbRange(RgbRange* pOutRange) const NN_NOEXCEPT
{
    return GetCurrentDisplay()->GetRgbRange(pOutRange);
}

nn::Result nn::vi::detail::DefaultDisplay::SetRgbRange(RgbRange range) NN_NOEXCEPT
{
    return GetCurrentDisplay()->SetRgbRange(range);
}

nn::Result nn::vi::detail::DefaultDisplay::SetUnderscan(int underscan) NN_NOEXCEPT
{
    NN_UNUSED(underscan);

    return nn::vi::ResultNotSupported();
}

nn::Result nn::vi::detail::DefaultDisplay::GetUnderscan(int* pOutUnderscan) const NN_NOEXCEPT
{
    NN_UNUSED(pOutUnderscan);

    return nn::vi::ResultNotSupported();
}

nn::Result nn::vi::detail::DefaultDisplay::SetAlpha(float alpha) NN_NOEXCEPT
{
    NN_UNUSED(alpha);

    return nn::vi::ResultNotSupported();
}

nn::Result nn::vi::detail::DefaultDisplay::SetPowerState(PowerState state) NN_NOEXCEPT
{
    NN_UNUSED(state);

    return nn::vi::ResultNotSupported();
}

nn::Result nn::vi::detail::DefaultDisplay::SetLayerStack(LayerStack id) NN_NOEXCEPT
{
    NN_UNUSED(id);

    return nn::vi::ResultNotSupported();
}

nn::Result nn::vi::detail::DefaultDisplay::SetCmuLuma(float luma) NN_NOEXCEPT
{
    return GetCurrentDisplay()->SetCmuLuma(luma);
}

nn::Result nn::vi::detail::DefaultDisplay::GetCmuLuma(float* pOutLuma) const NN_NOEXCEPT
{
    return GetCurrentDisplay()->GetCmuLuma(pOutLuma);
}

nn::Result nn::vi::detail::DefaultDisplay::GetHotplugEvent(nn::os::SystemEventType* pOutEvent) NN_NOEXCEPT
{
    return nn::vi::ResultNotSupported();
}

nn::vi::detail::IPhysicalDisplay* nn::vi::detail::DefaultDisplay::GetCurrentDisplay() const NN_NOEXCEPT
{
    // TODO: this should depend on console mode, not hotplug state
    DisplayModeInfo mode;

    if( m_Hdmi->GetMode(&mode).IsSuccess() )
    {
        return m_Hdmi;
    }
    else
    {
        return m_Lcd;
    }
}
