﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/lmem/lmem_ExpHeap.h>

namespace nn { namespace vi { namespace detail {

    class Allocator
    {
    public:
        Allocator(void* startAddress, size_t size) NN_NOEXCEPT;
        ~Allocator() NN_NOEXCEPT;

        template <typename T>
        void* Allocate() NN_NOEXCEPT
        {
            return nn::lmem::AllocateFromExpHeap(m_Heap, sizeof(T), NN_ALIGNOF(T));
        }

        void Free(void* ptr) NN_NOEXCEPT;
    private:
        nn::lmem::HeapHandle m_Heap;
    };

}}}
