﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <nn/vi/sf/vi_ServiceTypes.h>
#include "vi_DisplayHolder.h"
#include "vi_ObjectManager.h"

#define NN_VI_REQUIRES_DISPLAY_OPENED(pDisplay) \
    NN_SDK_REQUIRES_NOT_NULL(pDisplay);         \
    NN_SDK_REQUIRES(ObjectManager::FindValidDisplayHolder(pDisplay) != ObjectManager::GetValidDisplayHolderList()->end(), "Display is not opened.");

namespace nn{ namespace vi{

    DisplayId GetDisplayIdWithValidation(const Display* pDisplay) NN_NOEXCEPT;

    namespace {
        NN_FORCEINLINE DisplayHolder* GetDisplayHolder(Display* pDisplay) NN_NOEXCEPT
        {
            return reinterpret_cast<DisplayHolder*>(pDisplay);
        }

        NN_FORCEINLINE const DisplayHolder* GetDisplayHolder(const Display* pDisplay) NN_NOEXCEPT
        {
            return reinterpret_cast<const DisplayHolder*>(pDisplay);
        }

        NN_FORCEINLINE DisplayId GetDisplayId(const Display* pDisplay) NN_NOEXCEPT
        {
            auto pHolder = GetDisplayHolder(pDisplay);
            return pHolder->GetId();
        }
    }
}}
