﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <utils/RefBase.h>

#include <gui/IGraphicBufferProducer.h>
#include <gui/Surface.h>

struct ANativeWindow;

namespace android {
    class IGraphicBufferProducer;
    class Surface;
}

namespace nn{ namespace vi{ namespace native{

    struct NativeWindowHolder
    {
        android::sp<android::IGraphicBufferProducer> pProducer;
        android::sp<android::Surface> pSurface;

        ANativeWindow* GetNativeWindow() NN_NOEXCEPT;
        void Reset() NN_NOEXCEPT;
    };

}}}
