﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/os/os_SdkThreadCommon.h>
#include <nn/usb/pm/sfdl/usb_IPmService.sfdl.h>

#include "usb_PmServiceManager.h"
#include "usb_PmServiceImpl.h"
#include "usb_PmServiceName.h"

#include "../detail/usb_Util.h"
#include <nn/nn_SystemThreadDefinition.h>

using namespace nn::sf;

namespace nn {
namespace usb {
namespace pm {

Result PmServiceManager::Initialize(Pm *pPm) NN_NOEXCEPT
{
    m_pPm = pPm;

    // Register the service port
    NN_USB_ABORT_UNLESS_SUCCESS(
        InitializePort(0, PmLimitMaxSessionCount, ServiceName)
    );

    // Enable the service port.
    // The port doesn't accept any connection until we call LoopAuto().
    Start();

    // Create and start the service thread, which runs the LoopAuto()
    NN_USB_ABORT_UNLESS_SUCCESS(
        nn::os::CreateThread(&m_ServiceThread,
                             ServiceThreadEntry,
                             this,
                             m_ServiceThreadStack,
                             sizeof(m_ServiceThreadStack),
                             NN_SYSTEM_THREAD_PRIORITY(usb, PmIpcServer))
    );
    nn::os::SetThreadNamePointer(
        &m_ServiceThread, NN_SYSTEM_THREAD_NAME(usb, PmIpcServer)
    );
    nn::os::StartThread(&m_ServiceThread);

    return ResultSuccess();
}

Result PmServiceManager::Finalize() NN_NOEXCEPT
{
    // Break out of LoopAuto()
    RequestStop();

    // Destroy the service thread
    nn::os::WaitThread(&m_ServiceThread);
    nn::os::DestroyThread(&m_ServiceThread);

    // too bad, no official way to revoke "usb:pm" service path

    return ResultSuccess();
}

Result PmServiceManager::OnNeedsToAccept(int portIndex, PortForAllInOne *pPort) NN_NOEXCEPT
{
    return AcceptImpl(
        pPort,
        detail::Factory::CreateSharedEmplaced<IPmService, PmServiceImpl>(
            detail::UsbMemoryGetAllocator(),
            m_pPm
        )
    );
}

} // end of namespace pm
} // end of namespace usb
} // end of namespace nn
