﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/usb/pd/usb_PdCradle.h>
#include <nn/usb/pd/usb_PdManufacture.h>

#include "detail/usb_IPdCradleManager.h"

namespace nn { namespace usb { namespace pd {

// usb:pd:m と usb:pd:c は統合されたので、
// Manufacture 向け API の処理内容は Cradle 向け API と同じだが、
// API 互換性維持のため、Cradle 向け API の別名として Manufacture 向け API を残す。

void InitializeManufacture() NN_NOEXCEPT
{
    InitializeCradle();
}

void FinalizeManufacture() NN_NOEXCEPT
{
    FinalizeCradle();
}

void OpenManufactureSession( ManufactureSession* pOutSession ) NN_NOEXCEPT
{
    CradleSession session;
    OpenCradleSession(&session);
    pOutSession->_handle = session._handle;
}

void CloseManufactureSession( ManufactureSession* pSession ) NN_NOEXCEPT
{
    CradleSession session;
    session._handle = pSession->_handle;
    session._pEvent = pSession->_pEvent;
    CloseCradleSession(&session);
}

Result GetHostPdcFirmwareType( uint16_t* pData, ManufactureSession* pSession ) NN_NOEXCEPT
{
    if ( !pData )
    {
        return ResultInvalidAddress();
    }
    auto result = static_cast<nn::usb::pd::detail::IPdCradleSession*>(pSession->_handle)->GetHostPdcFirmwareType(reinterpret_cast<std::uint16_t*>(pData));
    if ( result.IsFailure() )
    {
        *pData = 0;
    }
    return result;
}

Result GetHostPdcFirmwareRevision( uint16_t* pData, ManufactureSession* pSession ) NN_NOEXCEPT
{
    if ( !pData )
    {
        return ResultInvalidAddress();
    }
    auto result = static_cast<nn::usb::pd::detail::IPdCradleSession*>(pSession->_handle)->GetHostPdcFirmwareRevision(reinterpret_cast<std::uint16_t*>(pData));
    if ( result.IsFailure() )
    {
        *pData = 0;
    }
    return result;
}

Result GetHostPdcManufactureId( uint16_t* pData, ManufactureSession* pSession ) NN_NOEXCEPT
{
    if ( !pData )
    {
        return ResultInvalidAddress();
    }
    auto result = static_cast<nn::usb::pd::detail::IPdCradleSession*>(pSession->_handle)->GetHostPdcManufactureId(reinterpret_cast<std::uint16_t*>(pData));
    if ( result.IsFailure() )
    {
        *pData = 0;
    }
    return result;
}

Result GetHostPdcDeviceId( uint16_t* pData, ManufactureSession* pSession ) NN_NOEXCEPT
{
    if ( !pData )
    {
        return ResultInvalidAddress();
    }
    auto result = static_cast<nn::usb::pd::detail::IPdCradleSession*>(pSession->_handle)->GetHostPdcDeviceId(reinterpret_cast<std::uint16_t*>(pData));
    if ( result.IsFailure() )
    {
        *pData = 0;
    }
    return result;
}

}}}
