﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

// 以下は固定で using を推奨
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using nn;
using nn.sf;
using std;


namespace nn.usb.pd
{
    [CppRefPath(@"<nn/usb/pd/usb_PdType.h>")]
    [ExternalStruct(20, 4)]
    public struct Status
    {
    }
}

namespace nn.usb.pd.detail
{
    // 実操作を担当する USB::PD のセッションオブジェクト。
    // セッションの取得は PdManager で行う。
    [CppRefPath("\"usb_IPdSession.h\"")]
    interface IPdSession : IServiceObject
    {
        // USB::PD インターフェースのうち SystemEvent を使うもの以外を記述
        [MethodId(0)]
        Result BindNoticeEvent(Out<NativeHandle> handle);

        [MethodId(1)]
        Result UnbindNoticeEvent();

        [MethodId(2)]
        Result GetStatus(Out<Status> outValue);

        [MethodId(3)]
        Result GetNotice(Out<uint32_t> outValue);

        [MethodId(4)]
        Result EnablePowerRequestNotice();

        [MethodId(5)]
        Result DisablePowerRequestNotice();

        [MethodId(6)]
        Result ReplyPowerRequest( bool isSuccess );
    }
    [CppRefPath("\"usb_IPdCradleSession.h\"")]
    interface IPdCradleSession : IServiceObject
    {
        // USB::PD インターフェースのうち SystemEvent を使うもの以外を記述
        [MethodId(0)]
        Result SetCradleVdo(uint32_t value, uint32_t command);

        [MethodId(1)]
        Result GetCradleVdo(Out<uint32_t> outValue, uint32_t command);

        [MethodId(2)]
        Result ResetCradleUsbHub();

        [MethodId(3)]
        Result GetHostPdcFirmwareType(Out<uint16_t> outValue);

        [MethodId(4)]
        Result GetHostPdcFirmwareRevision(Out<uint16_t> outValue);

        [MethodId(5)]
        Result GetHostPdcManufactureId(Out<uint16_t> outValue);

        [MethodId(6)]
        Result GetHostPdcDeviceId(Out<uint16_t> outValue);

        [MethodId(7)]
        Result EnableCradleRecovery(Out<bool> isSuspended);

        [MethodId(8)]
        Result DisableCradleRecovery(Out<bool> isSuspended);
    }

    // USB::PD セッションを返すマネージャークラス
    [CppRefPath("\"usb_IPdManager.h\"")]
    interface IPdManager : IServiceObject
    {
        [MethodId(0)]
        Result OpenSession(Out<IPdSession> outSession);
    }
    [CppRefPath("\"usb_IPdCradleManager.h\"")]
    interface IPdCradleManager : IServiceObject
    {
        [MethodId(0)]
        Result OpenCradleSession(Out<IPdCradleSession> outSession);
    }
}
