﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief
 *
 * @details
 *
 *
 */

#pragma once

#include <nn/usb/usb_Limits.h>

namespace nn { namespace usb { namespace hs {

struct ServiceManagerOption
{
    static const int SubDomainCountMax = HsLimitMaxSubdomainCount;
    static const int ObjectInSubDomainCountMax = HsLimitMaxObjectPerSubdomain;
    static const size_t PointerTransferBufferSize = 4096;
};

class Hs;

class ServiceManager
    : public nn::sf::HipcSimpleAllInOneServerManager<HsLimitMaxSessionCount, 1, ServiceManagerOption>
{
public:
    NN_IMPLICIT ServiceManager(Hs *pHs) : m_pHs(pHs)
    {

    }
    ~ServiceManager()
    {

    }


    Result Initialize();
    Result Finalize();

private:
    Hs                   *m_pHs;

    // client session threads
    nn::os::ThreadType   m_SessionThreads[HsLimitSfThreadCount];
    uint8_t              m_SessionThreadStack[HsLimitSfThreadCount][HsLimitSfThreadStackSize]NN_ALIGNAS(os::StackRegionAlignment);

    virtual nn::Result OnNeedsToAccept(int portIndex, PortForAllInOne *pPort) NN_NOEXCEPT;
    static void SessionThreadEntryStatic(void *arg)NN_NOEXCEPT;

};


} // end of namespace hs
} // end of namespace usb
} // end of namespace nn

