﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "usb_HsPrivateIncludes.h"

namespace nn { namespace usb { namespace hs {


Result PlatformController::Initialize(detail::UsbComplex *pComplex,
                                      detail::UsbController::Config* pConfig) NN_NOEXCEPT
{
    Result result;

    result = detail::UsbController::Initialize(pComplex, pConfig);
    m_pPlatform = m_pComplex->GetPlatform();

    return result;
}

Result PlatformController::Finalize() NN_NOEXCEPT
{
    Result result;

    result = detail::UsbController::Finalize();

    return result;
}

Result PlatformController::Enable() NN_NOEXCEPT
{
    Result result = ResultSuccess();

    memset(m_RootHubPortPowerRefCounts, 0, sizeof(m_RootHubPortPowerRefCounts));

    return result;
}

Result PlatformController::Disable() NN_NOEXCEPT
{
    Result result = ResultSuccess();

    return result;
}

Result PlatformController::Bind(Hs* pHs)
{
    NN_USB_ABORT_UNLESS(m_pHs == nullptr);

    m_pHs = pHs;

    return ResultSuccess();
}

Result PlatformController::Unbind()
{
    NN_USB_ABORT_UNLESS(m_pHs != nullptr);

    m_pHs = nullptr;

    return ResultSuccess();
}

Hs* PlatformController::LockStack()
{
    Hs* pHs = nullptr;
    if(m_pHs != nullptr)
    {
        m_pHs->LockStackMutex();
        pHs = m_pHs;
    }
    return pHs;
}

void PlatformController::UnlockStack()
{
    m_pHs->UnlockStackMutex();
}

int PlatformController::SetRootHubPortPower(HubPortNumber hubPortNumber, bool isPowerOn)
{
    int refCount = -1;

    if((hubPortNumber >= 1) && (hubPortNumber <= HsLimitMaxHubPortsCount))
    {
        if(isPowerOn)
        {
            refCount = ++m_RootHubPortPowerRefCounts[hubPortNumber - 1];
        }
        else
        {
            refCount = --m_RootHubPortPowerRefCounts[hubPortNumber - 1];
        }
    }

    return refCount;
}

} // end of namespace hs
} // end of namespace usb
} // end of namespace nn
