﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "usb_DsCommon.h"
#include "usb_DsProtocol.h"

namespace nn {
namespace usb {
namespace ds {

class DsInterfaceImpl;

class DsEndpointImpl
{
public:
    DsEndpointImpl(DsProtocol                  *pProtocol,
                   DsInterfaceImpl             *pInterface,
                   uint8_t                      endpointAddress,
                   nn::dd::ProcessHandle        processHandle) NN_NOEXCEPT;
    ~DsEndpointImpl() NN_NOEXCEPT;

    Result PostBufferAsync(nn::sf::Out<uint32_t>      pOutUrbId,
                           uint64_t                   address,
                           uint32_t                   bytes) NN_NOEXCEPT;

    Result Cancel() NN_NOEXCEPT;

    Result GetCompletionEvent(nn::sf::Out<nn::sf::NativeHandle> eventHandle) NN_NOEXCEPT;

    Result GetUrbReport(nn::sf::Out<UrbReport> report) NN_NOEXCEPT;

    Result Stall() NN_NOEXCEPT;

    Result SetZlt(bool zlt) NN_NOEXCEPT;

private:
    DsProtocol                            *m_pProtocol;
    nn::sf::SharedPointer<DsInterfaceImpl> m_pInterface;

    uint8_t                                m_Address;

    nn::dd::ProcessHandle                  m_ProcessHandle;
};


} // end of namespace hs
} // end of namespace usb
} // end of namespace nn

