﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "usb_PlatformNx.h"
#include "usb_ComplexTegra21x.h"

namespace nn {
namespace usb {
namespace detail {

Result UsbPlatformNx::Initialize() NN_NOEXCEPT
{
    Result result = ResultSuccess();

    // These modules may be on by default but should be explicitly disabled upon cold boot
    NN_USB_ABORT_UPON_ERROR(nn::pcv::SetPowerEnabled(nn::pcv::Module_XusbHost, false));
    NN_USB_ABORT_UPON_ERROR(nn::pcv::SetPowerEnabled(nn::pcv::Module_XusbDevice, false));
    NN_USB_ABORT_UPON_ERROR(nn::pcv::SetPowerEnabled(nn::pcv::Module_XusbSs, false));

    NN_USB_ABORT_UPON_ERROR(UsbPlatform::Initialize());

    NN_USB_ABORT_UPON_ERROR(AddComplex(&m_Tegra21x));

    return result;
}

Result UsbPlatformNx::Finalize() NN_NOEXCEPT
{
    Result result = ResultSuccess();

    NN_USB_ABORT_UPON_ERROR(DelComplex(&m_Tegra21x));
    NN_USB_ABORT_UPON_ERROR(UsbPlatform::Finalize());

    return result;
}

} // end of namespace detail
} // end of namespace usb
} // end of namespace nn
