﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
 * @file    usb_InputNotifier.h
 * @brief   Notifier to input detector on user activity
 */

#include <nn/nn_Common.h>
#include <nn/os.h>
#include <nn/usb/usb_Result.h>
#include <nn/usb/usb_Limits.h>

#include "usb_Util.h"

namespace nn {
namespace usb {
namespace detail {

class InputNotifier
{
public:
    InputNotifier() NN_NOEXCEPT
        : m_BreakEvent(nn::os::EventClearMode_ManualClear)
        , m_InputNotifyEvent(nn::os::EventClearMode_ManualClear)
    {}

    Result Initialize() NN_NOEXCEPT;
    Result Finalize() NN_NOEXCEPT;
    void Notify() NN_NOEXCEPT;

private:
    static void InputNotifierThreadEntry(void *arg) NN_NOEXCEPT
    {
        InputNotifier *pThis = reinterpret_cast<InputNotifier*>(arg);

        pThis->InputNotifierThreadLoop();
    }

    void InputNotifierThreadLoop() NN_NOEXCEPT;

private:
    // Input notifier thread
    nn::os::ThreadType                 m_InputNotifierThread;
    NN_OS_ALIGNAS_THREAD_STACK uint8_t m_InputNotifierThreadStack[UsbLimitInputNotifierThreadStackSize];

    // Input notifier thread control
    nn::os::Event                      m_BreakEvent;
    nn::os::Event                      m_InputNotifyEvent;
};

} // end of namespace detail
} // end of namespace usb
} // end of namespace nn
