﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/result/result_HandlingUtility.h>
#include <nn/nn_Abort.h>
#include <nn/nn_SdkLog.h>
#include <nn/nn_SdkAssert.h>

#include <nn/updater/updater.h>
#include "updater_BisSave.h"

namespace nn { namespace updater {

int GetFlagIndex(TargetBootMode mode)
{
    switch(mode)
    {
    case TargetBootMode::Normal:
        return 0;
    case TargetBootMode::Safe:
        return 1;
    default:
        return 2;
    }
}

BisSave::BisSave() NN_NOEXCEPT : m_SaveData(nullptr)
{
}

Result BisSave::Initialize(void* workBuffer, size_t size) NN_NOEXCEPT
{
    NN_SDK_ASSERT(size >= sizeof(BisSaveRaw), "Out of size of work buffer");
    NN_SDK_ASSERT(util::is_aligned(reinterpret_cast<uintptr_t>(workBuffer), 4096), "Invalid alignment");
    NN_SDK_ASSERT(util::is_aligned(size, BisAccessor::GetBlockSize()), "Invalid alignment size");
    NN_UNUSED(size);

    NN_RESULT_DO(m_Accessor.Initialize());
    m_SaveData = reinterpret_cast<BisSaveRaw*>(workBuffer);

    NN_RESULT_SUCCESS;
}

void BisSave::Finalize() NN_NOEXCEPT
{
    m_Accessor.Finalize();
}

Result BisSave::Load() NN_NOEXCEPT
{
    size_t size;
    NN_RESULT_DO(m_Accessor.Read(m_SaveData, &size, sizeof(BisSaveRaw), BootPartition1Type::BctSave_BCT63));
    NN_RESULT_SUCCESS;
}

Result BisSave::Save() NN_NOEXCEPT
{
    NN_RESULT_DO(m_Accessor.Write(m_SaveData, sizeof(BisSaveRaw), BootPartition1Type::BctSave_BCT63));
    NN_RESULT_SUCCESS;
}

// VerifyingUpdateFlag:
// 0 .. not required
// 1 .. required
bool BisSave::GetVerifyingRequiredFlag(TargetBootMode mode) NN_NOEXCEPT
{
    return m_SaveData->data[GetFlagIndex(mode)] != 0;
}

void BisSave::SetVerifyingRequiredFlag(TargetBootMode mode, bool verifyingRequired) NN_NOEXCEPT
{
    m_SaveData->data[GetFlagIndex(mode)] = (verifyingRequired ? 1 : 0);
}


}}
