﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nn/nn_Common.h>

#include <nn/ts/ts_Types.h>
#include <nn/ts/impl/ts.h>

namespace nn {
namespace ts {
namespace impl {
namespace detail {

class ISensorController
{
public:
    virtual ~ISensorController() NN_NOEXCEPT {};

    virtual nn::Result Initialize() NN_NOEXCEPT = 0;
    virtual nn::Result Finalize() NN_NOEXCEPT = 0;

    virtual LimitTemperature GetTemperatureRange() NN_NOEXCEPT = 0;

    virtual nn::Result GetTemperature(int* pOutTemperatureInteger) NN_NOEXCEPT = 0;
    virtual nn::Result GetTemperatureMilliC(int* pOutTemperatureMilliCInteger) NN_NOEXCEPT = 0;

    virtual void SetMeasurementMode(MeasurementMode powerMode) NN_NOEXCEPT = 0;

    // TODO: 温度検知の設定関連の関数を追加
};


} // detail
} // impl
} // ts
} // nn
