﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

//==============================================================================
namespace tmipc {
//==============================================================================

enum Result
{
    TMIPC_RESULT_OK = 0,                // Good.
    TMIPC_RESULT_NOT_IMPLEMENTED,       // Function not implemented somewhere in callstack.
    TMIPC_RESULT_FAILED,                // API failed.
    TMIPC_RESULT_CONNECT_FAILED,        // Connect to target failed.
    TMIPC_RESULT_CONNECT_NODE_IN_USE,   // Connect rejected, Node already in use, See Message.
    TMIPC_RESULT_CONNECT_VERSION_ERROR, // Connect version error.
    TMIPC_RESULT_PACKET_OVERRUN,        // Read or Write past end of packet.
    TMIPC_RESULT_USER_BUFFER_OVERRUN,   // Read or Write past end of user buffer.
    TMIPC_RESULT_DISCONNECTED,          // IPC target is disconnected.
    TMIPC_RESULT_DUPLICATE_SERVICE,     // Service is already registered.
    TMIPC_RESULT_UNKNOWN_SERVICE,       // Service is not known on this Node.
    TMIPC_RESULT_CANCELED,              // Operation was canceled.
    TMIPC_RESULT_TIMEOUT,               // Operation timed out.
    TMIPC_RESULT_NOT_INITIALIZED,       // The Node has not been initialized.
    TMIPC_RESULT_INVALID_PARAMETER,     // One of the parameter(s) is invalid.
    TMIPC_RESULT_CONNECT_PROTOCOL_ERROR,// The connection was refused because the tmipc protocol version is not supported. (i.e. compatibility with the future is not supported).
    TMIPC_RESULT_NOT_BACKWARDS_COMPATIBLE,// The packet failed to send because the specified task is not backwards compatible with older targets.

    TMIPC_RESULT_MAX,
    TMIPC_RESULT_BACKWARDS_COMPATIBILITY_SENTINEL, // When changed, the compiler will throw a static_assert
};

//==============================================================================

const char* ResultToString( Result result );

//==============================================================================
} // namespace tmipc
//==============================================================================
