﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "..\tmagent.h"
#include "tma_Socket.h"

//==============================================================================
namespace tma {
//==============================================================================

void Socket::InitSockets()
{
    // Nothing to do here.
}

//==============================================================================

void Socket::KillSockets()
{
    // Nothing to do here.
}

//==============================================================================

Socket::Socket()
{
    m_Socket = nn::socket::InvalidSocket;
}

//==============================================================================

Socket::Socket( int Socket )
{
    m_Socket = Socket;
}

//==============================================================================

Socket::~Socket()
{
}

//==============================================================================

s32 Socket::CreateUDP()
{
    int s = nn::socket::Socket( nn::socket::Family::Af_Inet, nn::socket::Type::Sock_Dgram, nn::socket::Protocol::IpProto_Udp );
    ASSERT( s != nn::socket::InvalidSocket );
    m_Socket = s;
    return( 0 );
}

//==============================================================================

s32 Socket::CreateTCP()
{
    int s = nn::socket::Socket( nn::socket::Family::Af_Inet, nn::socket::Type::Sock_Stream, nn::socket::Protocol::IpProto_Tcp );
    ASSERT( s != nn::socket::InvalidSocket );
    m_Socket = s;
    return( 0 );
}

//==============================================================================

bool Socket::IsValid()
{
    return( m_Socket != nn::socket::InvalidSocket );
}

//==============================================================================

s32 Socket::Listen( s32 Backlog )
{
    int res = 0;
    res = nn::socket::Listen( m_Socket, Backlog );
    ASSERT( res == 0 );
    return( res );
}

//==============================================================================

Socket Socket::Accept( nn::socket::SockAddr* pAddr, nn::socket::SockLenT* pAddrLen )
{
    s32 s = nn::socket::Accept( m_Socket, (nn::socket::SockAddr*)pAddr, pAddrLen );
    return( tma::Socket( s ) );
}

//==============================================================================

s32 Socket::Bind( nn::socket::SockAddr* pAddr, nn::socket::SockLenT AddrLen )
{
    int res = nn::socket::Bind( m_Socket, pAddr, AddrLen );
    ASSERT( res == 0 );
    return( res );
}

//==============================================================================

s32 Socket::EnableBroadcast()
{
    // Enable broadcasts on this socket.
//  int EnableBroadcast = 1;
    int res = 0;

    // NOTE: Broadcast is always enabled on Horizon socket0

    ASSERT( res == 0 );
    return( res );
}

//==============================================================================

s32 Socket::SetTCPNoDelay()
{
    // Disable nagle on this socket.
    int NoDelay = 1;
    int res = 0;

    nn::socket::SetSockOpt( m_Socket, nn::socket::Level::Sol_Tcp, nn::socket::Option::Tcp_NoDelay, reinterpret_cast<void*>(&NoDelay), sizeof(NoDelay) );
    res = 0;

    //ASSERT( res == 0 );
    return( res );
}

//==============================================================================

s32 Socket::Recv( void* pBuffer, s32 nBytes )
{
    ASSERT( m_Socket != nn::socket::InvalidSocket );

    // Receive the data
    s32 BytesReceived = 0;
    u8* p = (u8*)pBuffer;
    while( nBytes > 0 )
    {
        s32 Len = 0;
        Len = nn::socket::Recv( m_Socket, (char*)p, nBytes, nn::socket::MsgFlag::Msg_None );
        if( Len == nn::socket::SocketError )
        {
            break;
        }
        else if( Len == 0 )
        {
            break;
        }

        p             += Len;
        nBytes        -= Len;
        BytesReceived += Len;
    }

    // Return number of bytes received
    return( BytesReceived );
}

//==============================================================================

s32 Socket::Send( void* pBuffer, s32 nBytes )
{
    ASSERT( m_Socket != nn::socket::InvalidSocket );

    s32 BytesSent = 0;
    u8* p = (u8*)pBuffer;
    while( nBytes > 0 )
    {
        s32 Len = 0;
        Len = nn::socket::Send( m_Socket, (char*)p, nBytes, nn::socket::MsgFlag::Msg_None );
        if( Len == nn::socket::SocketError )
        {
            break;
        }
        p         += Len;
        nBytes    -= Len;
        BytesSent += Len;
    }

    // Return number of bytes sent
    return( BytesSent );
}

//==============================================================================

s32 Socket::RecvFrom( void* pBuffer, s32 nBytes, nn::socket::SockAddr* pAddr, nn::socket::SockLenT* pAddrLen )
{
    ASSERT( m_Socket != nn::socket::InvalidSocket );

    s32 Len = nn::socket::RecvFrom( m_Socket, (char*)pBuffer, nBytes, nn::socket::MsgFlag::Msg_None, pAddr, pAddrLen );

    // Return number of bytes received
    return( Len );
}

//==============================================================================

s32 Socket::SendTo( void* pBuffer, s32 nBytes, nn::socket::SockAddr* pAddr, nn::socket::SockLenT AddrLen )
{
    ASSERT( m_Socket != nn::socket::InvalidSocket );

    int Len = nn::socket::SendTo( m_Socket, (const char*)pBuffer, nBytes, nn::socket::MsgFlag::Msg_None, (const nn::socket::SockAddr*)pAddr, AddrLen );

    // Return number of bytes sent
    return( Len );
}

//==============================================================================

s32 Socket::Shutdown()
{
    int res = nn::socket::Shutdown( m_Socket, nn::socket::ShutdownMethod::Shut_RdWr );

    return( res );
}

//==============================================================================

s32 Socket::Close()
{
    int res = nn::socket::Close( m_Socket );

    m_Socket = nn::socket::InvalidSocket;
    return( res );
}

//==============================================================================
} // namespace tma
//==============================================================================
