﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "stdafx.h"

#if !defined(NN_TMA_SIM_INSTANCE)

#include "thread_tracker.h"

namespace tma
{
    namespace ThreadTracker
    {
        namespace
        {
            nn::os::ThreadType s_ThreadTypes[static_cast<u32>(ThreadId::Count)];
        }

        // Initialize the Thread Tracker.
        void Initialize()
        {
            memset(&s_ThreadTypes, 0, sizeof(s_ThreadTypes));
        }

        // Finalize the Thread Tracker.
        void Finalize()
        {
            memset( &s_ThreadTypes, 0, sizeof(s_ThreadTypes) );
        }

        // Registers a thread into the ThreadTypes array.
        void RegisterThread( const nn::os::ThreadType& Thread, ThreadId Id )
        {
            // Track the thread.
            if( (0 <= static_cast<s32>(Id)) && (Id < ThreadId::Count) )
            {
//NN_ABORT_UNLESS( (0 < static_cast<s32>(Id)), "tma::ThreadTracker::RegisterThreadId( 0x%p, %d ) who registered as slot 0?\n", &Thread, Id, Id, ThreadId::Count );
                s_ThreadTypes[static_cast<s32>(Id)] = Thread;
if( static_cast<s32>(Id) == 0 )
{
    NN_SDK_LOG( "[tma::ThreadTracker::RegisterThread]!!!!!!!! Registering Thread at Id: 0.\n" );
}

            }
//            else
//            {
//                NN_ABORT("tma::ThreadTracker::RegisterThreadId( 0x%p, %d ) failed.  Invalid Id: 0 <= '%d' < '%d'.\n", &Thread, Id, Id, ThreadId::Count );
//            }
        }

        // Unregisters the thread.
        void UnregisterThread( ThreadId Id )
        {
            // Untrack the thread.
            if ((0 <= static_cast<s32>(Id)) && (Id < ThreadId::Count))
            {
                nn::os::ThreadType &ThreadType{ s_ThreadTypes[static_cast<s32>(Id)] };
                memset( &ThreadType, 0, sizeof(ThreadType) );
            }
//            else
//            {
//                NN_ABORT( "tma::ThreadTracker::UnregisterThreadId( %d ) failed.  Invalid Id: 0 <= '%d' < '%d'.\n", Id, Id, ThreadId::Count );
//            }
        }

        // Returns the ThreadType for Id.
        const nn::os::ThreadType& GetThreadType( ThreadId Id )
        {
            nn::os::ThreadType& ThreadId{ s_ThreadTypes[static_cast<s32>(ThreadId::NotTracked)] };

            // Track the thread.
            if ((0 <= static_cast<s32>(Id)) && (Id < ThreadId::Count))
            {
                ThreadId = s_ThreadTypes[static_cast<s32>(Id)];
            }
//            else
//            {
//                NN_ABORT( "tma::ThreadTracker::GetThreadType( %d ) failed.  Invalid Id: 0 <= '%d' < '%d'.\n", Id, Id, ThreadId::Count );
//            }

            return ThreadId;
        }
    } // ThreadTracker.
} // tma.

#endif // NN_TMA_SIM_INSTANCE
