﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "tmagent.h"
#if !defined(NN_TMA_SIM_INSTANCE)
#include "tmipc/tmipc_result.h"
#include <nn/psc.h>

//==============================================================================
namespace tma {
//==============================================================================

// This namespace is the entry point for handling Power Management (PM) messages.
namespace PowerManagementMonitor
{
    typedef void (*EventCallback)( nn::psc::PmState State, const nn::psc::PmFlagSet& FlagSet );

    // Starts the Power Management monitoring thread.  Messages from PSC (PM)
    // will be sent to the given callback.
    //  In: pfEventCallback - The callback to send nn::psc::PmState messages
    //                        to, when received from PSC.
    // Returns: TMIPC_RESULT_OK upon success; otherwise the error that occurred.
    tmipc::Result   Initialize  ( EventCallback pfEventCallback );

    // Stops listening for PmState messages.  Cleans up and deallocates
    // resources.
    void            Finalize    ();
}

//==============================================================================
} // namespace tma
//==============================================================================

#endif // NN_TMA_SIM_INSTANCE
