﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdint>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_Types.h>
#include <nn/htc/htc_IHtcManager.h>

namespace nn { namespace tma {

class HtcManagerImpl
{
public:
    nn::Result GetEnvironmentVariable(nn::sf::Out<std::int32_t> pOutSize, const nn::sf::OutBuffer& outBuffer, const nn::sf::InBuffer& variableName) NN_NOEXCEPT;
    nn::Result GetEnvironmentVariableLength(nn::sf::Out<std::int32_t> pOutValue, const nn::sf::InBuffer& variableName) NN_NOEXCEPT;
    nn::Result GetHostConnectionEvent(nn::sf::Out<nn::sf::NativeHandle> pOutValue) NN_NOEXCEPT;
    nn::Result GetHostDisconnectionEvent(nn::sf::Out<nn::sf::NativeHandle> pOutValue) NN_NOEXCEPT;
    nn::Result GetHostConnectionEventForSystem(nn::sf::Out<nn::sf::NativeHandle> pOutValue) NN_NOEXCEPT;
    nn::Result GetHostDisconnectionEventForSystem(nn::sf::Out<nn::sf::NativeHandle> pOutValue) NN_NOEXCEPT;
    nn::Result GetBridgeIpAddress(const nn::sf::OutBuffer& outBuffer) NN_NOEXCEPT;
    nn::Result GetBridgeSubnetMask(const nn::sf::OutBuffer& outBuffer) NN_NOEXCEPT;
    nn::Result GetBridgeMacAddress(const nn::sf::OutBuffer& outBuffer) NN_NOEXCEPT;
    nn::Result GetBridgePort(const nn::sf::OutBuffer& outBuffer) NN_NOEXCEPT;
    nn::Result SetCradleAttached(bool bAttached) NN_NOEXCEPT;
    nn::Result GetWorkingDirectoryPath(const nn::sf::OutBuffer& outBuffer, const int32_t bufferSize) NN_NOEXCEPT;
    nn::Result GetWorkingDirectoryPathSize(nn::sf::Out<std::int32_t> pOutValue) NN_NOEXCEPT;
};

}}
