﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

//==============================================================================
//  INCLUDES
//==============================================================================

//#define CTRL_PERFORMANCE

#include "..\tmagent.h"
#include "..\tmipc\tmipc_service.h"
#include "hid_Task.h"
#include "hid_structures.h"

#ifdef CTRL_PERFORMANCE
#include <nn/os/os_Tick.h>
#endif // CTRL_PERFORMANCE

//==============================================================================
//  DEFINES
//==============================================================================

#define TMA_MACRO_VALUE(a) a
#define MAX_CHARACTERS_TO_KEEP TMA_MACRO_VALUE(100)
#define MAX_CONTROLLERS TMA_MACRO_VALUE(8)

//==============================================================================
namespace tma { namespace hid {
//==============================================================================

class AgentControllerService : public tmipc::Service
{
    struct controller_state
    {
        u32     m_Buttons;
        s32     m_Axis[4];
    };

protected:
            controller_state        m_ControllerState[MAX_CONTROLLERS];
            s32                     m_CharBuffer[MAX_CHARACTERS_TO_KEEP];
            u32                     m_iStartChar;
            u32                     m_iEndChar;

#ifdef CTRL_PERFORMANCE
            u32                     Counter;
            nn::os::Tick            SecStart;
#endif // CTRL_PERFORMANCE

public:
                            AgentControllerService  ();
                           ~AgentControllerService  ();

            void            Init                    ();
            void            Kill                    ();

            u32             GetControllerBufferSzie ( void );
            bool            GetControllerState      ( s32   iController, void* pStateBuffer );
            void            GetKeyboardInput        ( s32&  Character );

            void            UpdateControllerState   ( controller_data* pBuffer );
            void            UpdateKeyboardInput     ( s32   Character );

protected:
    virtual tmipc::Task*    OnNewTask               ( tmipc::Packet* pPacket );
};

//==============================================================================
// Global Controller service object
AgentControllerService&     GetControllerService( void );

//==============================================================================
}}
//==============================================================================
