﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../tmagent.h"
#include "../tmipc/tmipc_result.h"
#include "get_working_directory_path_task.h"

//==============================================================================
namespace tma { namespace generic_service {
//==============================================================================

GetWorkingDirectoryPathTask::GetWorkingDirectoryPathTask()
:   m_pBuffer( nullptr )
,   m_Result( Result::CONNECTION_FAILURE )
{
    m_TaskType = tmipc::TaskType_GetWorkingDirectoryPath;
}

//==============================================================================

GetWorkingDirectoryPathTask::~GetWorkingDirectoryPathTask()
{
}

//==============================================================================

void GetWorkingDirectoryPathTask::OnInitiate( tmipc::Packet* pPacket )
{
    (void)pPacket;
    ASSERT( 0 );
}

//==============================================================================

void GetWorkingDirectoryPathTask::OnRecvPacket( tmipc::Packet* pPacket )
{
    m_Result = Result::CONNECTION_FAILURE;

    // Read the Working Directory Path from the Packet.
    s32 BufferLength{ m_BufferLength };
    s32 BytesRead{ 0 };
    s32 Result = pPacket->ReadString( m_pBuffer, BufferLength, &BytesRead );
    if( Result == tmipc::TMIPC_RESULT_OK )
    {
        // All good.
        m_Result = Result::SUCCESS;
    }
    else
    {
        if( Result == tmipc::TMIPC_RESULT_USER_BUFFER_OVERRUN )
        {
            m_Result = Result::NOT_ENOUGH_BUFFER;   // Buffer overflow.
        }
        else if( Result == tmipc::TMIPC_RESULT_PACKET_OVERRUN )
        {
            m_Result = Result::CONNECTION_FAILURE;  // Packet overflow.
        }
    }
    if( BufferLength > 0 )
    {
        m_pBuffer[BufferLength - 1] = 0;
    }

    // Done.
    Complete();

// Debug only.
//    NN_SDK_LOG( "[tma]!!! GetWorkingDirectoryPathTask::OnRecvPacket: '%s'. Bytes read: %d. Result: %d. m_Result: %d.\n", m_pBuffer, BytesRead, Result, m_Result );
}

//==============================================================================

void GetWorkingDirectoryPathTask::OnSendPacket( tmipc::Packet* pPacket )
{
    // TODO - Handle Packet
    (void)pPacket;
}

//==============================================================================
}} // namespace
//==============================================================================
