﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../tmagent.h"
#include "generic_service_api.h"
#include "generic_service.h"
#include "get_working_directory_path_size_task.h"
#include "get_working_directory_path_task.h"
#include <nn/os.h>
#include <nn/htc/htc_Result.h>

//==============================================================================
namespace nn { namespace tma { namespace generic_service {
//==============================================================================

nn::Result GetWorkingDirectoryPathImpl( char* pBuffer, int32_t bufferLength ) NN_NOEXCEPT
{
    if (::tma::GetEnableDisconnectionEmulationFlag())
    {
        return nn::htc::ResultConnectionFailure();
    }

    ::tma::generic_service::Service& Service{ ::tma::generic_service::GetService() };
    const ::tma::generic_service::GetWorkingDirectoryPathTask::Result kResult{ Service.GetWorkingDirectoryPath( pBuffer, bufferLength ) };

    switch( kResult )
    {
        case ::tma::generic_service::GetWorkingDirectoryPathTask::Result::SUCCESS:
        return nn::ResultSuccess();
        case ::tma::generic_service::GetWorkingDirectoryPathTask::Result::NOT_ENOUGH_BUFFER:
        return nn::htc::ResultNotEnoughBuffer();
        case ::tma::generic_service::GetWorkingDirectoryPathTask::Result::CONNECTION_FAILURE:
        return nn::htc::ResultConnectionFailure();
        default:
        return nn::os::ResultInternalError();
    };
}

//==============================================================================

nn::Result GetWorkingDirectoryPathSize( int32_t* pLength ) NN_NOEXCEPT
{
    if (::tma::GetEnableDisconnectionEmulationFlag())
    {
        return nn::htc::ResultConnectionFailure();
    }

    ::tma::generic_service::Service& Service{ ::tma::generic_service::GetService() };
    const ::tma::generic_service::GetWorkingDirectoryPathSizeTask::Result kResult{ Service.GetWorkingDirectoryPathSize(pLength) };

    switch( kResult )
    {
        case ::tma::generic_service::GetWorkingDirectoryPathSizeTask::Result::SUCCESS:
        return nn::ResultSuccess();
        case ::tma::generic_service::GetWorkingDirectoryPathSizeTask::Result::CONNECTION_FAILURE:
        return nn::htc::ResultConnectionFailure();
        default:
        return nn::os::ResultInternalError();
    };
}

//==============================================================================
}}} // namespace
//==============================================================================
