﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

//==============================================================================
//  INCLUDES
//==============================================================================

#include "../tmagent.h"
#include "generic_service.h"

//==============================================================================
namespace tma { namespace generic_service {
//==============================================================================

Service::Service()
{
    DEJA_TRACE( "tma::service::Service::Service", "Service" );
    m_ServiceId = HashString( "GenericService::Service" );
}

//==============================================================================

Service::~Service()
{
    DEJA_TRACE( "tma::service::Service::~Service", "~Service" );
}

//==============================================================================

void Service::Init()
{
    DEJA_TRACE( "tma::service::Service::Init", "Init" );
    Create();
}

//==============================================================================

void Service::Kill()
{
    DEJA_TRACE( "tma::service::Service::Kill", "Kill" );
    Destroy();
}

//==============================================================================

tmipc::Task* Service::OnNewTask( tmipc::Packet* pPacket )
{
    (void)pPacket;
    ASSERT( 0 );
    return( NULL );
}

//==============================================================================

GetWorkingDirectoryPathTask::Result Service::GetWorkingDirectoryPath(char* pBuffer, int32_t bufferLength) NN_NOEXCEPT
{
    GetWorkingDirectoryPathTask::Result Result{ GetWorkingDirectoryPathTask::Result::CONNECTION_FAILURE };
    {
        void* pMem = s_Allocate( sizeof( GetWorkingDirectoryPathTask ) );
        GetWorkingDirectoryPathTask* pTask = new (pMem)GetWorkingDirectoryPathTask;
        pTask->SetServicesManager( m_pServicesManager );
        pTask->SetServiceId( m_ServiceId );
        pTask->SetTaskId( m_pServicesManager->AllocTaskId() );
        pTask->SetTaskType( tmipc::TaskType_GetWorkingDirectoryPath );

        tmipc::Packet* pPacket = pTask->AllocSendPacket( true );
        pTask->m_pBuffer = pBuffer;
        pTask->m_BufferLength = bufferLength;

        m_pServicesManager->SubmitTask( pTask, pPacket );
        pTask->WaitComplete( TMIPC_INFINITE );
        // Successfully read the variable?
        Result = pTask->m_Result;
        // Done with the task.
        pTask->~GetWorkingDirectoryPathTask();
        s_Deallocate( pTask, sizeof( GetWorkingDirectoryPathTask ) );
    }

    return Result;
}

//==============================================================================

GetWorkingDirectoryPathSizeTask::Result  Service::GetWorkingDirectoryPathSize(int32_t* pLength) NN_NOEXCEPT
{
    GetWorkingDirectoryPathSizeTask::Result  Result{ GetWorkingDirectoryPathSizeTask::Result::CONNECTION_FAILURE };
    {
        void* pMem = s_Allocate( sizeof( GetWorkingDirectoryPathSizeTask ) );
        GetWorkingDirectoryPathSizeTask* pTask = new (pMem)GetWorkingDirectoryPathSizeTask();
        pTask->SetServicesManager( m_pServicesManager );
        pTask->SetServiceId( m_ServiceId );
        pTask->SetTaskId( m_pServicesManager->AllocTaskId() );
        pTask->SetTaskType( tmipc::TaskType_GetWorkingDirectoryPathSize );

        tmipc::Packet* pPacket = pTask->AllocSendPacket( true );
        pPacket->SetTaskId( pTask->GetTaskId() );
        pPacket->SetTaskType( pTask->GetTaskType() );
        pTask->m_pLength = pLength;

        m_pServicesManager->SubmitTask( pTask, pPacket );
        pTask->WaitComplete( TMIPC_INFINITE );
        // Successfully read the variable?
        Result = pTask->m_Result;
        // Done with the task.
        pTask->~GetWorkingDirectoryPathSizeTask();
        s_Deallocate( pTask, sizeof( GetWorkingDirectoryPathSizeTask ) );
    }

    return Result;
}

//==============================================================================
}} // namespace
//==============================================================================
