﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "..\tmagent.h"
#include "env_Service.h"
#include <nn/os.h>
#include <nn/util/util_FormatString.h>
#include <nn/nn_SdkAssert.h>
#include <cstdarg>
#include <nn/htc/htc_Result.h>
#include "env_opcodes.h"

//==============================================================================
namespace nn { namespace tma { namespace env {
//==============================================================================

nn::Result GetEnvironmentVariableImpl( int32_t* pLength, char* pBuffer, int32_t bufferLength, const char* pName ) NN_NOEXCEPT
{
    if (::tma::GetEnableDisconnectionEmulationFlag())
    {
        return nn::htc::ResultConnectionFailure();
    }

    ::tma::env::AgentEnvService& EnvService = ::tma::env::GetEnvService();
    s32 Result = EnvService.GetEnvironmentVariable( pLength, pBuffer, bufferLength, pName );

    switch( Result )
    {
        case ::tma::env::TMA_ENV_RESULT_SUCCESS:
        return nn::ResultSuccess();
        case ::tma::env::TMA_ENV_RESULT_NOT_FOUND:
        return nn::os::ResultInvalidParameter();
        case ::tma::env::TMA_ENV_RESULT_BUFFER_TOO_SMALL:
        return nn::os::ResultOutOfMemory();
        case ::tma::env::TMA_ENV_RESULT_PACKET_TOO_SMALL:
        return nn::os::ResultOverflow();
        case ::tma::env::TMA_ENV_RESULT_BAD_PACKET:
        return nn::htc::ResultConnectionFailure();
        default:
        return nn::os::ResultInternalError();
    };
}

//==============================================================================

nn::Result GetEnvironmentVariableLength( int32_t* pLength, const char* pName ) NN_NOEXCEPT
{
    if (::tma::GetEnableDisconnectionEmulationFlag())
    {
        return nn::htc::ResultConnectionFailure();
    }

    ::tma::env::AgentEnvService& EnvService = ::tma::env::GetEnvService();
    s32 Result = EnvService.GetEnvironmentVariableLength( pLength, pName );

    switch( Result )
    {
        case ::tma::env::TMA_ENV_RESULT_SUCCESS:
        return nn::ResultSuccess();
        case ::tma::env::TMA_ENV_RESULT_NOT_FOUND:
        return nn::os::ResultInvalidParameter();
        case ::tma::env::TMA_ENV_RESULT_PACKET_TOO_SMALL:
        return nn::os::ResultOverflow();
        case ::tma::env::TMA_ENV_RESULT_BAD_PACKET:
        return nn::htc::ResultConnectionFailure();
        default:
        return nn::os::ResultInternalError();
    };
}

//==============================================================================
}}} // namespace
//==============================================================================
