﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "..\tmipc\tmipc_packet.h"
#include "..\tmipc\tmipc_task.h"
#include "..\tm_result.h"
#include "..\tma\tma_Thread.h"
#include "diagnostics_opcodes.h"

//==============================================================================
namespace tma { namespace diagnostics {
//==============================================================================

namespace memory_tracking
{
    void        Init            ( nn::lmem::HeapHandle  HeapHandle );
    void        Kill            ();
    void        Report          ();

    void        Remember        ( size_t                Size,
                                  void*                 pMem,
                                  const char*           pFileName,
                                  int                   LineNumber );
    void        Forget          ( void*                 pMem );
}

//==============================================================================

class DiagnosticsTask : public tmipc::Task
{
public:
    explicit        DiagnosticsTask     ();
                    ~DiagnosticsTask    ();

virtual void        OnInitiate          ( tmipc::Packet*        pPacket );
virtual void        OnRecvPacket        ( tmipc::Packet*        pPacket );
virtual void        OnSendPacket        ( tmipc::Packet*        pPacket );

protected:

};

//==============================================================================
}}
//==============================================================================
