﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

// WARNING: THERE ARE TWO COPIES OF THIS FILE WHICH MUST STAY IN SYNC

#pragma once

#include "..\tmagent.h"
#include <nn/osdbg.h>
#include <nn/dmnt/dmnt_Api.h>

//==============================================================================
namespace tma { namespace dbghlp {
//==============================================================================

nn::Result Initialize() NN_NOEXCEPT;
nn::Result Finalize() NN_NOEXCEPT;

nn::Result QueryDebugProcessMemory(nn::svc::MemoryInfo* pBlockInfo, nn::svc::PageInfo* pPageInfo, nn::svc::Handle process, uintptr_t addr) NN_NOEXCEPT;

nn::Result BreakDebugProcess(nn::svc::Handle debug) NN_NOEXCEPT;
nn::Result TerminateDebugProcess(nn::svc::Handle debug) NN_NOEXCEPT;
nn::Result CloseHandle(nn::svc::Handle handle) NN_NOEXCEPT;

nn::Result LoadImage( nn::svc::Handle* pHandle, const char* pFileName, const char* pArgs ) NN_NOEXCEPT;
nn::Result AttachByProgramId( nn::svc::Handle* pHandle, nn::Bit64* pPID, nn::Bit64 ProgramId ) NN_NOEXCEPT;
nn::Result AttachOnLaunch( nn::svc::Handle* pHandle, nn::Bit64* pPID, nn::Bit64 ProgramId ) NN_NOEXCEPT;
nn::Result GetProcessId(nn::Bit64* pOut, nn::svc::Handle process) NN_NOEXCEPT;
//nn::Result GetProcessIdFromProgramId( nn::Bit64* pOut, nn::Bit64 ProgramId ) NN_NOEXCEPT;
nn::Result WaitSynchronization(int32_t* pOut, const nn::svc::Handle handles[], int32_t numHandles, int64_t ns) NN_NOEXCEPT;
nn::Result GetDebugEvent(nn::svc::DebugEventInfo* pInfo, nn::svc::Handle debug) NN_NOEXCEPT;
nn::Result GetProcessModuleInfo(int* pOutCount, nn::dbg::ModuleInfo* pOutModules, int num, nn::os::ProcessId pid) NN_NOEXCEPT;
nn::Result GetProcessList(int32_t* pNumProcesses, nn::Bit64 pProcessIds[], int32_t arraySize) NN_NOEXCEPT;
nn::Result GetProcessHandle(nn::svc::Handle* pOut, nn::Bit64 processId) NN_NOEXCEPT;
nn::Result GetThreadList(int32_t* pNumThreads, nn::Bit64 pThreadIds[], int32_t arraySize, nn::svc::Handle domain) NN_NOEXCEPT;
nn::Result GetDebugThreadContext(nn::svc::ThreadContext* pContext, nn::svc::Handle debug, nn::Bit64 threadId, nn::Bit32 controlFlags) NN_NOEXCEPT;
nn::Result GetAllDebugThreadInfo( nn::svc::Handle debug, void* pThreadData, nn::Bit32 ElementSize, nn::osdbg::ThreadInfo ThreadInfo[], nn::Bit32 ArraySize ) NN_NOEXCEPT;
nn::Result ContinueDebugEvent(nn::svc::Handle debug, nn::Bit32 flags, nn::Bit64 threadIds[], nn::Bit32 size) NN_NOEXCEPT;
nn::Result ReadDebugProcessMemory(uintptr_t buf, nn::svc::Handle debug, uintptr_t addr, size_t size) NN_NOEXCEPT;
nn::Result WriteDebugProcessMemory(nn::svc::Handle debug, uintptr_t buf, uintptr_t addr, size_t size) NN_NOEXCEPT;
nn::Result SetDebugThreadContext(nn::svc::Handle debug, nn::Bit64 threadId, const nn::svc::ThreadContext& context, nn::Bit32 controlFlags) NN_NOEXCEPT;
nn::Result GetDebugThreadParam(nn::Bit64* pOut1, nn::Bit32* pOut2, nn::svc::Handle debug, nn::Bit64 threadId, nn::svc::DebugThreadParam select) NN_NOEXCEPT;
nn::Result InitializeThreadInfo(nn::osdbg::ThreadInfo* pThreadInfo, nn::svc::Handle debugHandle, const nn::svc::DebugInfoCreateProcess* pDebugInfoCreateProcess, const nn::svc::DebugInfoCreateThread* pDebugInfoCreateThread) NN_NOEXCEPT;
nn::Result SetHardwareBreakPoint( nn::svc::HardwareBreakPointRegisterName regNo,  nn::Bit64 control, nn::Bit64 value ) NN_NOEXCEPT;

nn::Result GetProcessMemoryDetails(int32_t* pNumOfMemoryBlocks, nn::svc::MemoryInfo pBlockInfo[], int32_t arraySize, nn::svc::Handle debugHandle) NN_NOEXCEPT;
nn::Result GetJitDebugProcessList(int32_t* pNumProcesses, nn::os::ProcessId pProcessIds[], int32_t arraySize) NN_NOEXCEPT;
nn::Result CreateCoreDump( char *FileName, coredump::coredump_compiled_data* pDetails, nn::svc::Handle debugHandle ) NN_NOEXCEPT;

nn::Result InitiateCoreDump( char *FileName, coredump::coredump_compiled_data* pDetails, nn::svc::Handle debugHandle, u64* pSessionId ) NN_NOEXCEPT;
nn::Result ContinueCoreDump( u64 SessionId, s32* pPercentDone ) NN_NOEXCEPT;
nn::Result AddTTYToCoreDump( char* pData, u32 SizeOfData , u64 SessionId ) NN_NOEXCEPT;
nn::Result AddImageToCoreDump( char* pData, u32 SizeOfData , u64 SessionId  ) NN_NOEXCEPT;
nn::Result CloseCoreDump( u64 SessionId ) NN_NOEXCEPT;

//==============================================================================
}} // namespace
//==============================================================================
