﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "..\tmipc\tmipc_packet.h"
#include "..\tmipc\tmipc_task.h"
#include "dbg_Message.h"
#include "dbg_ProcessMgr.h"
#include "..\tma\tma_Thread.h"

//==============================================================================
namespace tma { namespace dbg {
//==============================================================================

class DebugTask : public tmipc::Task
{
public:
    static void     Initialize              ();
    static void     Finalize                ();

    explicit        DebugTask               ( ProcessMgr*          pProcessMgr );
                   ~DebugTask               ();

    void            OnInitiate              ( tmipc::Packet*       pPacket );
    void            OnRecvPacket            ( tmipc::Packet*       pPacket );
    void            OnSendPacket            ( tmipc::Packet*       pPacket );

    void            Start                   ( TMAgent_message_type MessageType,
                                              process_id            ProcessId,
                                              void*                 pData,
                                              s32                   SizeOfData);

    // Related to load executable (LoadElf) thread.
    struct WorkTaskInfo
    {
        WorkTaskInfo( tmipc::Task* pTask, u32 CommandCode, ProcessMgr* pProcessMgr )
        {
            memset( this, 0, sizeof(WorkTaskInfo) );
            m_pDebugTask = pTask;
            m_CommandCode = CommandCode;
            m_pProcessMgr = pProcessMgr;
        };

        tmipc::Task*                m_pDebugTask;
        ProcessMgr*                 m_pProcessMgr;
        void                        (*m_Execute)( WorkTaskInfo* );
        u32                         m_CommandCode;
        u64                         m_ProcessId;
        u64                         m_ParamValue;
        break_point                 m_BreakPoint;
        WriteDumpCommandArgs        m_WriteDumpArgs;
        StepDebugCommandArgs        m_StepArgs;
        WriteMemoryCommandArgs      m_WriteMemoryArgs;
        ReadMemCommandArgs          m_ReadMemoryArgs;
        ReadRegDefsCommandArgs      m_ReadRegDefsArgs;
        ReadRegDataCommandArgs      m_ReadRegisterArgs;
        WriteRegisterCommandArgs    m_WriteRegisterArgs;
    };

    static void     ProcessCommand          ( WorkTaskInfo*        pTask );
    static void     SendReply               ( tmipc::Task*         pDebugTask,
                                              TMAgent_message_type MessageType,
                                              u64                  ProcessId,
                                              s32                  ResultCode,
                                              void*                Data,
                                              s32                  DataSize );
protected:

    static void     IssueSimpleCommand      ( WorkTaskInfo* pInfo );
    static void     SetBreakpoint           ( WorkTaskInfo* pInfo );
    static void     Step                    ( WorkTaskInfo* pInfo );
    static void     WriteMemory             ( WorkTaskInfo* pInfo );
    static void     ReadMemory              ( WorkTaskInfo* pInfo );
    static void     ReadRegisterDefinitions ( WorkTaskInfo* pInfo );
    static void     ReadRegisterData        ( WorkTaskInfo* pInfo );
    static void     WriteRegisterData       ( WorkTaskInfo* pInfo );
    static void     WriteDump               ( WorkTaskInfo* pInfo );
    static void     GetMemorySegmentInfo    ( WorkTaskInfo* pInfo );
    static void     AttachByProgramId       ( WorkTaskInfo* pInfo );


    static void*    WorkThread              ( void*         pArgs );

private:
    ProcessMgr*     m_pProcessMgr;
    static Thread   m_WorkThread;
    static MQ       m_WorkMQ;

    //============================
    // Attach on start processing
    u64             m_ProgramId;
    Thread*         m_pThread;
    static void*    HandleAttachOnStart     ( void*         pArgs );

    //============================
    // Load exe processing
    char            m_FileName[1024];
    char            m_Args[1024];

    static void*    HandleLoadExe           ( void*         pArgs );
    static void*    HandleLoadExe2          ( void*         pArgs );
};

//==============================================================================

class MiniCoreDump : public tmipc::Task
{
public:
    explicit        MiniCoreDump        ( ProcessMgr*       pProcessMgr );
                   ~MiniCoreDump        ();

virtual void        OnInitiate          ( tmipc::Packet*            pPacket );
virtual void        OnRecvPacket        ( tmipc::Packet*            pPacket );
virtual void        OnSendPacket        ( tmipc::Packet*            pPacket );

private:
    ProcessMgr*     m_pProcessMgr;
    static void     DoMiniDump          ( DebugTask::WorkTaskInfo*  pInfo );
};

//==============================================================================
}}
//==============================================================================
