﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "../tma/tma_MQ.h"
#include "../tmipc/tmipc_task.h"
#include "../tmipc/tmipc_packet.h"
#include "../tmipc/tmipc_service.h"
#include "dbg_Message.h"
#include "dbg_Exception.h"
#include "dbg_SimTask.h"

//==============================================================================
namespace tma { namespace dbg {
//==============================================================================

class ProcessMgr;

class SimDebugService : public tmipc::Service
{
private:

//==============================================================================
// Structs for passing data to our dispatch thread
struct DispatchDebugTask
{
    explicit DispatchDebugTask( )
    {
        m_ShouldDispatch    = false;
        m_CommandOp         = 0;
    }
    explicit DispatchDebugTask( s32 CommandOp, tma::dbg::process_id ProcessId )
    {
        m_ShouldDispatch    = true;
        m_CommandOp         = CommandOp;
        m_ProcessId         = ProcessId;
    }
    bool                    m_ShouldDispatch;
    s32                     m_CommandOp;
    tma::dbg::process_id    m_ProcessId;
};

struct DispatchDebugMessageTask : DispatchDebugTask
{
    explicit DispatchDebugMessageTask( tma::dbg::process_id ProcessId, const char* pMessage )
        : DispatchDebugTask( dbg::TMAgent_message_type::TMAGENT_MESSAGE_TYPE_INFO, ProcessId )
    {
        strcpy( m_Message, pMessage );
    }
    char                m_Message[1024];
};

struct DispatchDebugExceptionTask : DispatchDebugTask
{
    explicit DispatchDebugExceptionTask( tma::dbg::process_id ProcessId, Exception* pExceptionData )
        : DispatchDebugTask( dbg::TMAgent_message_type::TMAGENT_MESSAGE_TYPE_EXCEPTION, ProcessId )
    {
        memcpy( &m_exceptionData, pExceptionData, sizeof(Exception) );
    }
    Exception           m_exceptionData;
};

        tma::Thread     m_DispatchTaskThread;
        MQ              m_DispatchTaskQ;
static void*            DispatchTaskThread  ( void*    pArg );

public:
                        SimDebugService     ();
                       ~SimDebugService     ();

          void          Init                ();
          void          Kill                ();
          tmipc::Task*  StartDebugTask      ( TMAgent_message_type  Type,
                                             process_id             ProcessId,
                                             void*                  pData,
                                             s32                    SizeOfData );

          void          NotifyException     ( dbg::process_id       ProcessId,
                                              Exception*            pExceptionData );

          void          NotifyMessage       ( dbg::process_id       ProcessId,
                                              const char*           pMessage );

protected:
virtual   tmipc::Task*  OnNewTask           ( tmipc::Packet*        pPacket );

};

SimDebugService& GetSimDebugService( void );

//==============================================================================
}}
//==============================================================================
