﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

//==============================================================================
namespace tma {
//==============================================================================

enum process_state
{
    PS_BKPT,            // At break, possible stepping in progress

    PS_HALT,            // Stop the DevKit without exception reporting
    PS_RESUME,          // Resume execution after PS_HALT

    PS_RUNNING,         // Process is Running, not Stepping

    PS_UNKNOWN,
    PS_NOT_STARTED,
    PS_CLONE,
    PS_EXITING,
};


enum DebugException: uint32_t
{
// Based on nn::svc::DebugException
    DEBUG_EXCEPTION_UNDEFINED_INSTRUCTION = 0,
    DEBUG_EXCEPTION_ACCESS_VIOLATION_INSTRUCT,
    DEBUG_EXCEPTION_ACCESS_VIOLATION_DATA,
    DEBUG_EXCEPTION_DATATYPE_MISSALIGNED,
    DEBUG_EXCEPTION_ATTACH_BREAK,
    DEBUG_EXCEPTION_BREAKPOINT,
    DEBUG_EXCEPTION_USER_BREAK,
    DEBUG_EXCEPTION_DEBUGGER_BREAK,
    DEBUG_EXCEPTION_UNDEFINED_SYSTEMCALL,
    DEBUG_EXCEPTION_MEMORY_SYSTEM_ERROR,
// Defined only in Oasis
    DEBUG_EXCEPTION_MODULE_LIST_CHANGE = 200,
    DEBUG_EXCEPTION_STACK_OVERFLOW,
    DEBUG_EXCEPTION_CODE_CHANGES_APPLIED,
    DEBUG_EXCEPTION_PROCESS_EXIT = 256,
};

//==============================================================================
} // namespace tma
//==============================================================================
